/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import java.util.Collection;

public interface UpgradeTask {
    public String getBuildNumber();

    public String getShortDescription();

    public void doUpgrade(boolean var1) throws Exception;

    public Collection<String> getErrors();

    public boolean isReindexRequired();

    public static class Status {
        private static JiraProperties jiraSystemProperties = JiraSystemProperties.getInstance();

        public static void setTaskDone(String taskId) {
            jiraSystemProperties.setProperty(Status.asPropertyName(taskId), (Object)"true");
        }

        public static boolean isTaskDone(String taskId) {
            return jiraSystemProperties.getProperty(Status.asPropertyName(taskId)) != null;
        }

        private static String asPropertyName(String taskId) {
            return "jira.task." + taskId + ".complete";
        }
    }
}

