/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.timezone;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.timezone.TimeZoneIdsProvider;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;
import org.joda.time.DateTimeZone;

class TimeZoneIds
implements TimeZoneIdsProvider {
    static final long cNow = System.currentTimeMillis();
    private static final Logger log = Logger.getLogger(TimeZoneIds.class);
    @ClusterSafe
    static final Cache<TimeZone, TimeZone> canonicalTimeZoneMap = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<TimeZone, TimeZone>(){

        public TimeZone load(TimeZone timeZone) {
            try {
                DateTimeZone dateTimeZone = DateTimeZone.forTimeZone((TimeZone)timeZone);
                return dateTimeZone.toTimeZone();
            }
            catch (Exception e) {
                return timeZone;
            }
        }
    });

    TimeZoneIds() {
    }

    @Override
    public Set<String> getCanonicalIds() {
        HashSet jdkIds = Sets.newHashSet((Object[])TimeZone.getAvailableIDs());
        Set jodaIds = DateTimeZone.getAvailableIDs();
        Sets.SetView commonIds = Sets.intersection((Set)jodaIds, (Set)jdkIds);
        TreeSet zones = Sets.newTreeSet();
        for (String id : commonIds) {
            zones.add(new ZoneData(id, DateTimeZone.forID((String)id)));
        }
        HashSet canonicalIds = Sets.newHashSetWithExpectedSize((int)zones.size());
        for (ZoneData zone : zones) {
            if (!zone.isCanonical()) continue;
            canonicalIds.add(zone.getCanonicalID());
        }
        return canonicalIds;
    }

    @Override
    public TimeZone canonicalise(TimeZone timeZone) {
        try {
            return (TimeZone)canonicalTimeZoneMap.get((Object)timeZone);
        }
        catch (ExecutionException ex) {
            log.debug((Object)("Time zone with id '" + timeZone.getID() + "' not recognised."));
            return timeZone;
        }
    }

    private static class ZoneData
    implements Comparable {
        private final String iID;
        private final DateTimeZone iZone;

        ZoneData(String id, DateTimeZone zone) {
            this.iID = id;
            this.iZone = zone;
        }

        public String getID() {
            return this.iID;
        }

        public String getCanonicalID() {
            return this.iZone.getID();
        }

        public boolean isCanonical() {
            return this.getID().equals(this.getCanonicalID());
        }

        public int compareTo(Object obj) {
            int offsetB;
            ZoneData other = (ZoneData)obj;
            int offsetA = this.iZone.getStandardOffset(cNow);
            if (offsetA < (offsetB = other.iZone.getStandardOffset(cNow))) {
                return -1;
            }
            if (offsetA > offsetB) {
                return 1;
            }
            int result = this.getCanonicalID().compareTo(other.getCanonicalID());
            if (result != 0) {
                return result;
            }
            if (this.isCanonical()) {
                if (!other.isCanonical()) {
                    return -1;
                }
            } else if (other.isCanonical()) {
                return 1;
            }
            return this.getID().compareTo(other.getID());
        }
    }
}

