/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.AlreadyExecutingException;
import com.atlassian.jira.task.ForkedThreadExecutor;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.RequiresTaskInformation;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskDescriptorImpl;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskMatcher;
import com.atlassian.jira.task.TaskProgressAdapter;
import com.atlassian.jira.task.TaskProgressEvent;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Functions;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.util.concurrent.BlockingCounter;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class TaskManagerImpl
implements TaskManager {
    private static final Logger log = Logger.getLogger(TaskManagerImpl.class);
    private static final Function<TaskDescriptorImpl<?>, TaskDescriptor<?>> COPY = new Function<TaskDescriptorImpl<?>, TaskDescriptor<?>>(){

        public TaskDescriptor<?> get(TaskDescriptorImpl<?> input) {
            return TaskManagerImpl.copy(input);
        }
    };
    private final Map<Long, TaskDescriptorImpl<?>> taskMap = new ConcurrentHashMap();
    private final AtomicLong taskIdGen = new AtomicLong(0L);
    private final JiraAuthenticationContext authenticationContext;
    private final BlockingCounter activeThreads = new BlockingCounter();
    private ExecutorService executorService;

    public TaskManagerImpl(JiraAuthenticationContext authenticationContext) {
        this(authenticationContext, new ForkedThreadExecutor(5, new TaskManagerThreadFactory()));
    }

    public TaskManagerImpl(JiraAuthenticationContext authenticationContext, ExecutorService executorService) {
        this.authenticationContext = authenticationContext;
        this.start();
    }

    @Override
    public <V> TaskDescriptor<V> submitTask(@Nonnull Callable<V> callable, @Nonnull String taskDescription, @Nonnull TaskContext taskContext) throws RejectedExecutionException, AlreadyExecutingException {
        return this.submitTask(callable, taskDescription, taskContext, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> TaskDescriptor<V> submitTask(@Nonnull Callable<V> callable, @Nonnull String taskDescription, @Nonnull TaskContext taskContext, boolean cancellable) throws RejectedExecutionException, AlreadyExecutingException {
        Assertions.notNull((String)"callable", callable);
        Assertions.notNull((String)"taskContext", (Object)taskContext);
        Assertions.notNull((String)"taskDescription", (Object)taskDescription);
        Long taskId = this.taskIdGen.incrementAndGet();
        TaskProgressAdapter taskProgressAdapter = null;
        if (callable instanceof ProvidesTaskProgress) {
            taskProgressAdapter = new TaskProgressAdapter();
        }
        TaskDescriptorImpl taskDescriptor = new TaskDescriptorImpl(taskId, taskDescription, taskContext, this.authenticationContext.getLoggedInUser(), taskProgressAdapter, cancellable);
        FutureTask futureTask = new FutureTask(new TaskCallableDecorator(callable, taskDescriptor, this.authenticationContext, this.activeThreads));
        taskDescriptor.setFuture(futureTask);
        if (callable instanceof ProvidesTaskProgress) {
            taskProgressAdapter.setTaskDescriptor(taskDescriptor);
            ((ProvidesTaskProgress)((Object)callable)).setTaskProgressSink(taskProgressAdapter);
        }
        if (callable instanceof RequiresTaskInformation) {
            RequiresTaskInformation requiresTaskInformation = (RequiresTaskInformation)((Object)callable);
            requiresTaskInformation.setTaskDescriptor(taskDescriptor);
        }
        TaskManagerImpl taskManagerImpl = this;
        synchronized (taskManagerImpl) {
            TaskDescriptor<V> testTaskDescriptor = this.getLiveTask(taskContext);
            if (testTaskDescriptor != null) {
                throw new AlreadyExecutingException(testTaskDescriptor, "A task with this context has already been submitted");
            }
            this.taskMap.put(taskId, taskDescriptor);
        }
        this.submitTaskInternal(futureTask);
        return new TaskDescriptorImpl(taskDescriptor);
    }

    @Override
    public boolean removeTask(Long taskId) {
        return this.taskMap.remove(taskId) != null;
    }

    void submitTaskInternal(FutureTask<?> futureTask) {
        this.executorService.submit(futureTask);
    }

    @Override
    public void start() {
        if (this.executorService == null || this.executorService.isShutdown()) {
            this.executorService = new ForkedThreadExecutor(5, new TaskManagerThreadFactory());
        }
    }

    @Override
    public boolean shutdownAndWait(long waitSeconds) {
        boolean val;
        if (waitSeconds < 0L) {
            throw new IllegalArgumentException("waitSeconds must be >= 0");
        }
        this.executorService.shutdown();
        try {
            val = this.executorService.awaitTermination(waitSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            val = this.executorService.isTerminated();
        }
        this.logRunningTasksOnShutdown();
        return val;
    }

    @Override
    public void shutdownNow() {
        this.executorService.shutdownNow();
    }

    @Override
    public boolean awaitUntilActiveTasksComplete(long seconds) {
        try {
            return this.activeThreads.await(seconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return this.activeThreads.getCount() == 0;
        }
    }

    @Override
    public <V> TaskDescriptor<V> getLiveTask(@Nonnull TaskContext taskContext) {
        Assertions.notNull((String)"taskContext", (Object)taskContext);
        TaskDescriptor<?> result = this.findFirstTask(new ActiveMatcher(taskContext));
        return result;
    }

    @Override
    public <V> TaskDescriptor<V> getTask(Long taskId) {
        if (taskId == null) {
            return null;
        }
        TaskDescriptorImpl<?> input = this.taskMap.get(taskId);
        return TaskManagerImpl.copy(input);
    }

    @Override
    public boolean hasLiveTaskWithContext(@Nonnull TaskContext taskContext) {
        return this.hasTask(new ActiveMatcher(taskContext));
    }

    @Override
    public boolean hasTaskWithContext(final @Nonnull TaskContext taskContext) {
        Assertions.notNull((String)"taskContext", (Object)taskContext);
        return this.hasTask(new TaskMatcher(){

            @Override
            public boolean match(TaskDescriptor<?> descriptor) {
                return taskContext.equals(descriptor.getTaskContext());
            }
        });
    }

    @Override
    public TaskDescriptor<?> findFirstTask(@Nonnull TaskMatcher matcher) {
        return (TaskDescriptor)CollectionUtil.findFirstMatch(this.taskMap.values(), (Predicate)new TaskMatcherPredicate(matcher));
    }

    @Override
    public Collection<TaskDescriptor<?>> findTasks(TaskMatcher matcher) {
        return this.findTasksInternal(matcher);
    }

    @Override
    public Collection<TaskDescriptor<?>> getAllTasks() {
        return this.sortIntoIdOrder(Transformed.collection(this.taskMap.values(), COPY));
    }

    @Override
    public Collection<TaskDescriptor<?>> getLiveTasks() {
        return this.sortIntoIdOrder(this.findTasksInternal(new TaskMatcher(){

            @Override
            public boolean match(TaskDescriptor<?> descriptor) {
                return !descriptor.isFinished();
            }
        }));
    }

    private Collection<TaskDescriptor<?>> findTasksInternal(TaskMatcher matcher) {
        Assertions.notNull((String)"matcher", (Object)matcher);
        return Transformed.collection((Collection)CollectionUtil.filter(this.taskMap.values(), (Predicate)new TaskMatcherPredicate(matcher)), (Function)Functions.coerceToSuper());
    }

    private boolean hasTask(TaskMatcher matcher) {
        return CollectionUtil.contains(this.taskMap.values(), (Predicate)new TaskMatcherPredicate(matcher));
    }

    private static <V> TaskDescriptor<V> copy(TaskDescriptorImpl<V> input) {
        if (input == null) {
            return null;
        }
        return new TaskDescriptorImpl<V>(input);
    }

    private List<TaskDescriptor<?>> sortIntoIdOrder(Collection<TaskDescriptor<?>> input) {
        ArrayList result = new ArrayList(input);
        Collections.sort(result, new Comparator<TaskDescriptor<?>>(){

            @Override
            public int compare(TaskDescriptor<?> o1, TaskDescriptor<?> o2) {
                return o1.getTaskId().compareTo(o2.getTaskId());
            }
        });
        return result;
    }

    private void logRunningTasksOnShutdown() {
        Collection<TaskDescriptor<?>> liveTasks = this.getLiveTasks();
        if (!liveTasks.isEmpty()) {
            log.warn((Object)"Shutting down task manager while the following tasks are still executing:");
            for (TaskDescriptor<?> taskDescriptor : liveTasks) {
                TaskProgressEvent event;
                StringBuilder sb = new StringBuilder();
                sb.append("Task Id ");
                sb.append(taskDescriptor.getTaskId());
                TaskProgressEvent taskProgressEvent = event = taskDescriptor.getTaskProgressIndicator() == null ? null : taskDescriptor.getTaskProgressIndicator().getLastProgressEvent();
                if (event != null) {
                    sb.append(" - ");
                    sb.append(event.getTaskProgress());
                    sb.append("% complete");
                }
                sb.append(" - ");
                sb.append(taskDescriptor.getDescription());
                log.warn((Object)sb.toString());
            }
        }
    }

    private final class TaskMatcherPredicate
    implements Predicate<TaskDescriptor<?>> {
        final TaskMatcher matcher;

        TaskMatcherPredicate(TaskMatcher matcher) {
            this.matcher = (TaskMatcher)Assertions.notNull((String)"matcher", (Object)matcher);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean evaluate(TaskDescriptor<?> input) {
            TaskDescriptor<?> taskDescriptor = input;
            synchronized (taskDescriptor) {
                return this.matcher.match(input);
            }
        }
    }

    private static class TaskManagerThreadFactory
    implements ThreadFactory {
        private final AtomicLong threadId = new AtomicLong(0L);

        private TaskManagerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable, "JiraTaskExectionThread-" + this.threadId.incrementAndGet());
            t.setDaemon(true);
            return t;
        }
    }

    private static class ActiveMatcher
    implements TaskMatcher {
        private final TaskContext taskContext;

        public ActiveMatcher(TaskContext taskContext) {
            this.taskContext = taskContext;
        }

        @Override
        public boolean match(TaskDescriptor<?> descriptor) {
            return !descriptor.isFinished() && this.taskContext.equals(descriptor.getTaskContext());
        }
    }

    private static class TaskCallableDecorator<V>
    implements Callable<V> {
        private final AtomicReference<Callable<V>> actualCallableRef;
        private final TaskDescriptorImpl<V> taskDescriptor;
        private final JiraAuthenticationContext context;
        private final BlockingCounter counter;

        private TaskCallableDecorator(Callable<V> callable, TaskDescriptorImpl<V> taskDescriptor, JiraAuthenticationContext context, BlockingCounter counter) {
            this.counter = counter;
            Assertions.notNull((String)"callable", callable);
            Assertions.notNull((String)"taskDescriptor", taskDescriptor);
            Assertions.notNull((String)"context", (Object)context);
            this.actualCallableRef = new AtomicReference<Callable<Callable<V>>>(callable);
            this.taskDescriptor = taskDescriptor;
            this.context = context;
        }

        @Override
        public V call() throws Exception {
            this.preCallSetup();
            this.taskDescriptor.setStartedTimestamp();
            this.counter.up();
            try {
                Callable actualCallable = this.actualCallableRef.getAndSet(null);
                if (actualCallable != null) {
                    Object v = actualCallable.call();
                    return v;
                }
                throw new IllegalStateException("Callable executed twice.");
            }
            finally {
                this.postCallTearDown();
            }
        }

        private void preCallSetup() {
            JiraThreadLocalUtils.preCall();
            this.context.setLoggedInUser(this.taskDescriptor.getUser());
        }

        private void postCallTearDown() {
            this.taskDescriptor.setFinishedTimestamp();
            this.counter.down();
            JiraThreadLocalUtils.postCall(log, new JiraThreadLocalUtils.ProblemDeterminationCallback(){

                @Override
                public void onOpenTransaction() {
                    log.error((Object)("The task '" + TaskCallableDecorator.this.taskDescriptor.getDescription() + "' has left an open database transaction in play."));
                }
            });
        }
    }
}

