/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskProgressIndicator;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;

class TaskDescriptorImpl<V>
implements TaskDescriptor<V> {
    private final TaskContext taskContext;
    private final Date submittedTime;
    private final Long taskId;
    private final String description;
    private final User user;
    private final String progressURL;
    private final TaskProgressIndicator taskProgressIndicator;
    private volatile Future<V> future;
    private Date startedTimestamp;
    private Date finishedTimestamp;
    private final boolean cancellable;

    TaskDescriptorImpl(@Nonnull Long taskId, @Nonnull String description, @Nonnull TaskContext taskContext, User user, TaskProgressIndicator taskProgressIndicator, boolean cancellable) {
        this.cancellable = cancellable;
        Assertions.notNull((String)"taskId", (Object)taskId);
        Assertions.notNull((String)"description", (Object)description);
        Assertions.notNull((String)"taskContext", (Object)taskContext);
        this.taskContext = taskContext;
        this.description = description;
        this.taskId = taskId;
        this.user = user;
        this.submittedTime = new Date();
        this.taskProgressIndicator = taskProgressIndicator;
        this.future = null;
        this.progressURL = taskContext.buildProgressURL(taskId);
        this.initialiseTime(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TaskDescriptorImpl(@Nonnull TaskDescriptorImpl<V> copiedTaskDescriptor) {
        Assertions.notNull((String)"copiedTaskDescriptor", copiedTaskDescriptor);
        TaskDescriptorImpl<V> taskDescriptorImpl = copiedTaskDescriptor;
        synchronized (taskDescriptorImpl) {
            this.taskContext = copiedTaskDescriptor.getTaskContext();
            this.description = copiedTaskDescriptor.getDescription();
            this.taskId = copiedTaskDescriptor.getTaskId();
            this.user = copiedTaskDescriptor.getUser();
            this.submittedTime = copiedTaskDescriptor.getSubmittedTimestamp();
            this.taskProgressIndicator = copiedTaskDescriptor.getTaskProgressIndicator();
            this.progressURL = copiedTaskDescriptor.getProgressURL();
            this.future = copiedTaskDescriptor.future;
            this.cancellable = copiedTaskDescriptor.isCancellable();
            this.initialiseTime(copiedTaskDescriptor.getStartedTimestamp(), copiedTaskDescriptor.getFinishedTimestamp());
        }
    }

    private synchronized void initialiseTime(Date startedTimestamp, Date finishedTimestamp) {
        this.startedTimestamp = startedTimestamp;
        this.finishedTimestamp = finishedTimestamp;
    }

    void setFuture(Future<V> future) {
        this.future = future;
    }

    @Override
    public synchronized long getElapsedRunTime() {
        if (this.startedTimestamp == null) {
            return 0L;
        }
        if (this.finishedTimestamp == null) {
            return System.currentTimeMillis() - this.startedTimestamp.getTime();
        }
        return this.finishedTimestamp.getTime() - this.startedTimestamp.getTime();
    }

    @Override
    public V getResult() throws ExecutionException, InterruptedException {
        return this.future.get();
    }

    @Override
    public boolean isCancellable() {
        return this.cancellable;
    }

    @Override
    public void cancel() {
        if (this.future != null) {
            this.future.cancel(false);
        }
    }

    @Override
    public boolean isCancelled() {
        return this.future != null && this.future.isCancelled();
    }

    @Override
    public synchronized boolean isStarted() {
        return this.startedTimestamp != null;
    }

    @Override
    public synchronized boolean isFinished() {
        return this.finishedTimestamp != null;
    }

    @Override
    public synchronized Date getFinishedTimestamp() {
        if (this.finishedTimestamp != null) {
            return new Date(this.finishedTimestamp.getTime());
        }
        return null;
    }

    synchronized void setFinishedTimestamp() {
        if (this.startedTimestamp == null) {
            throw new IllegalStateException("Task has not yet started.");
        }
        if (this.finishedTimestamp != null) {
            throw new IllegalStateException("Task has already finished.");
        }
        this.finishedTimestamp = new Date();
    }

    @Override
    public synchronized Date getStartedTimestamp() {
        if (this.startedTimestamp != null) {
            return new Date(this.startedTimestamp.getTime());
        }
        return null;
    }

    synchronized void setStartedTimestamp() {
        if (this.startedTimestamp != null) {
            throw new IllegalStateException("Task has already started.");
        }
        this.startedTimestamp = new Date();
    }

    @Override
    public Date getSubmittedTimestamp() {
        return new Date(this.submittedTime.getTime());
    }

    @Override
    public Long getTaskId() {
        return this.taskId;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    @Override
    public TaskProgressIndicator getTaskProgressIndicator() {
        return this.taskProgressIndicator;
    }

    @Override
    public String getProgressURL() {
        return this.progressURL;
    }
}

