/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentAccessorWorker;
import com.atlassian.jira.startup.DefaultJiraLauncher;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.studio.startup.StudioStartupHooks;
import com.atlassian.jira.studio.startup.StudioStartupHooksLocator;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LauncherContextListener
implements ServletContextListener {
    private static final String STARTUP_UNEXPECTED = "startup-unexpected";
    private static final Logger log = LoggerFactory.getLogger(LauncherContextListener.class);
    private static final String LOG4J = "log4j.properties";
    private JiraLauncher launcher;

    public void contextInitialized(ServletContextEvent sce) {
        try {
            log.debug("Launching JIRA");
            StudioStartupHooks startupHooks = StudioStartupHooksLocator.getStudioStartupHooks();
            this.configureLog4j(startupHooks);
            startupHooks.beforeJiraStart();
            this.initialiseJiraApi();
            this.launcher = new DefaultJiraLauncher();
            this.launcher.start();
            startupHooks.afterJiraStart();
        }
        catch (Exception e) {
            log.error("Unable to start JIRA.", (Throwable)e);
            JohnsonEventContainer.get((ServletContext)sce.getServletContext()).addEvent(new Event(EventType.get((String)STARTUP_UNEXPECTED), "Unexpected exception during JIRA startup. This JIRA instance will not be able to recover. Please check the logs for details", EventLevel.get((String)"fatal")));
        }
        catch (Error e) {
            log.error("Unable to start JIRA due to Java Error.", (Throwable)e);
            throw e;
        }
    }

    private void initialiseJiraApi() {
        log.debug("Initing Jira");
        ComponentAccessor.initialiseWorker((ComponentAccessor.Worker)new ComponentAccessorWorker());
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.launcher == null) {
            throw new IllegalStateException("Context destroyed without being initialized first. JIRA launcher is confused.");
        }
        this.launcher.stop();
        this.launcher = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureLog4j(StudioStartupHooks startupHooks) {
        Properties properties = new Properties();
        InputStream resource = this.getClass().getClassLoader().getResourceAsStream(LOG4J);
        if (resource != null) {
            try {
                properties.load(resource);
            }
            catch (IOException e) {
                log.warn("Unable read current log4j configuration. Assuming blank configuration.", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)resource);
            }
        } else {
            log.warn("Unable to find 'log4j.properties' on class path.");
        }
        Properties newConfig = startupHooks.getLog4jConfiguration(properties);
        if (newConfig != null) {
            PropertyConfigurator.configure((Properties)newConfig);
        }
    }
}

