/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.appconsistency.clustering.NodeIdCheck;
import com.atlassian.jira.appconsistency.clustering.SharedHomeCheck;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.FailoverProperties;
import com.atlassian.jira.startup.JiraStartupLogger;
import com.atlassian.jira.startup.StartupCheck;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class JiraClusteringConfigChecklist {
    private static final Logger log = Logger.getLogger(JiraClusteringConfigChecklist.class);
    private final JiraStartupLogger startupLogger = new JiraStartupLogger();
    private final ClusterManager clusterManager;
    private final FailoverProperties failoverProperties;
    private final StartupCheck[] checklist;
    private volatile boolean checksDone;
    private volatile boolean success;
    private List<StartupCheck> failedStartupChecks = Lists.newArrayList();

    public JiraClusteringConfigChecklist(ClusterManager clusterManager, FailoverProperties failoverProperties) {
        this.clusterManager = clusterManager;
        this.failoverProperties = failoverProperties;
        this.checklist = new StartupCheck[]{new SharedHomeCheck(failoverProperties), new NodeIdCheck(failoverProperties)};
    }

    public boolean startupOK() {
        this.success = true;
        if (!this.checksDone && this.failoverProperties.propertyFileExists()) {
            log.debug((Object)"Performing Clustering start up checks");
            this.success = this.doStartupChecks();
            this.checksDone = true;
        }
        return this.success;
    }

    private boolean doStartupChecks() {
        boolean success = true;
        log.debug((Object)"Doing clustering config checklist");
        for (StartupCheck startupCheck : this.checklist) {
            log.debug((Object)("Doing startup check " + startupCheck.getName()));
            if (startupCheck.isOk()) continue;
            this.startupLogger.printMessage(startupCheck.getFaultDescription(), Level.FATAL);
            this.failedStartupChecks.add(startupCheck);
            success = false;
        }
        return success;
    }

    public List<StartupCheck> getFailedStartupChecks() {
        return this.failedStartupChecks;
    }
}

