/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.instrumentation.operations.OpTimerFactory;
import com.atlassian.jdk.utilities.runtimeinformation.RuntimeInformationFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.issue.index.DefaultIndexManager;
import com.atlassian.jira.mail.BotocssThreadLauncher;
import com.atlassian.jira.startup.ActiveServicesLauncher;
import com.atlassian.jira.startup.BootstrapContainerLauncher;
import com.atlassian.jira.startup.ChecklistLauncher;
import com.atlassian.jira.startup.ClusterPassivationLauncher;
import com.atlassian.jira.startup.ClusteringChecklistLauncher;
import com.atlassian.jira.startup.ClusteringLauncher;
import com.atlassian.jira.startup.ComponentContainerLauncher;
import com.atlassian.jira.startup.DatabaseChecklistLauncher;
import com.atlassian.jira.startup.DatabaseLauncher;
import com.atlassian.jira.startup.FailedPluginsLauncher;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.startup.JiraStartupChecklist;
import com.atlassian.jira.startup.NotificationInstanceKiller;
import com.atlassian.jira.startup.SystemInfoLauncher;
import com.atlassian.jira.upgrade.ConsistencyCheckImpl;
import com.atlassian.jira.upgrade.PluginSystemLauncher;
import com.atlassian.jira.util.devspeed.JiraDevSpeedTimer;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.threadlocal.BruteForceThreadLocalCleanup;
import com.atlassian.threadlocal.RegisteredThreadLocals;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DefaultJiraLauncher
implements JiraLauncher {
    private static final Logger log = Logger.getLogger(DefaultJiraLauncher.class);
    private final ChecklistLauncher startupChecklist;
    private final BootstrapContainerLauncher bootstrapContainerLauncher;
    private final ComponentContainerLauncher componentContainerLauncher;
    private final NotificationInstanceKiller notificationInstanceKiller;
    private final DatabaseLauncher databaseLauncher;
    private final PluginSystemLauncher pluginSystemLauncher;
    private final ConsistencyCheckImpl consistencyChecker;
    private final SystemInfoLauncher systemInfoLauncher;
    private final FailedPluginsLauncher preDbFailedPluginsLauncher;
    private final FailedPluginsLauncher postDbFailedPluginsLauncher;
    private final ClusteringLauncher clusteringLauncher;
    private final ClusteringChecklistLauncher clusteringChecklistLauncher;
    private final ActiveServicesLauncher activeServicesLauncher;
    private final ClusterPassivationLauncher clusterPassivationLauncher;
    private final JiraProperties jiraSystemProperties = JiraSystemProperties.getInstance();
    private final BotocssThreadLauncher botocssThreadLauncher;

    public DefaultJiraLauncher() {
        this.startupChecklist = new ChecklistLauncher(this.jiraSystemProperties);
        this.bootstrapContainerLauncher = new BootstrapContainerLauncher();
        this.componentContainerLauncher = new ComponentContainerLauncher();
        this.notificationInstanceKiller = new NotificationInstanceKiller();
        this.databaseLauncher = new DatabaseLauncher(this.jiraSystemProperties);
        this.pluginSystemLauncher = new PluginSystemLauncher();
        this.consistencyChecker = new ConsistencyCheckImpl();
        this.systemInfoLauncher = new SystemInfoLauncher();
        this.preDbFailedPluginsLauncher = new FailedPluginsLauncher();
        this.postDbFailedPluginsLauncher = new FailedPluginsLauncher();
        this.clusteringLauncher = new ClusteringLauncher();
        this.clusteringChecklistLauncher = new ClusteringChecklistLauncher();
        this.activeServicesLauncher = new ActiveServicesLauncher();
        this.clusterPassivationLauncher = new ClusterPassivationLauncher();
        this.botocssThreadLauncher = new BotocssThreadLauncher();
    }

    @Override
    public void start() {
        JiraDevSpeedTimer.run(this.getStartupName(), new Runnable(){

            @Override
            public void run() {
                DefaultJiraLauncher.this.preDbLaunch();
                DefaultJiraLauncher.this.postDbLaunch();
            }
        });
        DefaultIndexManager.flushThreadLocalSearchers();
    }

    private void preDbLaunch() {
        this.systemInfoLauncher.start();
        this.bootstrapContainerLauncher.start();
        this.startupChecklist.start();
        this.preDbFailedPluginsLauncher.start();
    }

    private void postDbLaunch() {
        if (JiraStartupChecklist.startupOK()) {
            final DatabaseConfigurationManager dbcm = (DatabaseConfigurationManager)ComponentAccessor.getComponentOfType(DatabaseConfigurationManager.class);
            final ServletContext servletContext = ServletContextProvider.getServletContext();
            dbcm.doNowOrWhenDatabaseConfigured(new Runnable(){

                @Override
                public void run() {
                    new DatabaseChecklistLauncher(dbcm, servletContext, DefaultJiraLauncher.this.jiraSystemProperties).start();
                }
            }, "Database Checklist Launcher");
            dbcm.doNowOrWhenDatabaseActivated(new Runnable(){

                @Override
                public void run() {
                    if (!JohnsonEventContainer.get((ServletContext)servletContext).hasEvents()) {
                        DefaultJiraLauncher.this.componentContainerLauncher.start();
                        DefaultJiraLauncher.this.databaseLauncher.start();
                        DefaultJiraLauncher.this.clusteringChecklistLauncher.start();
                        DefaultJiraLauncher.this.clusteringLauncher.start();
                        DefaultJiraLauncher.this.pluginSystemLauncher.start();
                        DefaultJiraLauncher.this.consistencyChecker.initialise(ServletContextProvider.getServletContext());
                        DefaultJiraLauncher.this.activeServicesLauncher.start();
                        DefaultJiraLauncher.this.notificationInstanceKiller.deleteAfterDelay();
                        DefaultJiraLauncher.this.clusterPassivationLauncher.start();
                        DefaultJiraLauncher.this.botocssThreadLauncher.start();
                    }
                }
            }, "Post database-configuration launchers");
            this.postDbFailedPluginsLauncher.start();
        }
    }

    @Override
    public void stop() {
        log.info((Object)"Stopping launchers");
        this.botocssThreadLauncher.stop();
        this.clusterPassivationLauncher.stop();
        this.activeServicesLauncher.stop();
        this.consistencyChecker.destroy(ServletContextProvider.getServletContext());
        this.pluginSystemLauncher.stop();
        this.clusteringLauncher.stop();
        this.databaseLauncher.stop();
        this.startupChecklist.stop();
        OpTimerFactory opTimerFactory = (OpTimerFactory)ComponentAccessor.getComponent(OpTimerFactory.class);
        this.componentContainerLauncher.stop();
        this.bootstrapContainerLauncher.stop();
        this.systemInfoLauncher.stop();
        this.preDbFailedPluginsLauncher.stop();
        this.postDbFailedPluginsLauncher.stop();
        this.cleanupAfterOurselves(opTimerFactory);
    }

    private void cleanupAfterOurselves(OpTimerFactory opTimerFactory) {
        this.cleanupThreadLocals(opTimerFactory);
        LogManager.shutdown();
    }

    private void cleanupThreadLocals(OpTimerFactory opTimerFactory) {
        Instrumentation.snapshotThreadLocalOperationsAndClear(opTimerFactory);
        RegisteredThreadLocals.reset();
        BruteForceThreadLocalCleanup.cleanUp((ClassLoader)this.getClass().getClassLoader());
    }

    private String getStartupName() {
        String jvmInputArguments = StringUtils.defaultString((String)RuntimeInformationFactory.getRuntimeInformation().getJvmInputArguments());
        boolean rebel = jvmInputArguments.contains("jrebel.jar");
        boolean debugMode = jvmInputArguments.contains("-Xdebug");
        return "jira.startup" + (debugMode ? ".debug" : ".run") + (rebel ? ".jrebel" : "");
    }
}

