/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.startup.JiraDatabaseConfigChecklist;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class DatabaseChecklistLauncher
implements JiraLauncher {
    private static final Logger log = Logger.getLogger(DatabaseChecklistLauncher.class);
    private final DatabaseConfigurationManager dbcm;
    private final ServletContext servletContext;
    private final JiraProperties jiraSystemProperties;

    public DatabaseChecklistLauncher(DatabaseConfigurationManager dbcm, ServletContext servletContext, JiraProperties jiraSystemProperties) {
        this.dbcm = dbcm;
        this.servletContext = servletContext;
        this.jiraSystemProperties = jiraSystemProperties;
    }

    @Override
    public void start() {
        JiraDatabaseConfigChecklist jiraPostDatabaseChecklist = new JiraDatabaseConfigChecklist(this.dbcm, this.jiraSystemProperties);
        if (jiraPostDatabaseChecklist.startupOK()) {
            log.info((Object)"JIRA database startup checks completed successfully.");
        } else {
            StartupCheck failedCheck = jiraPostDatabaseChecklist.getFailedStartupCheck();
            String desc = failedCheck.getFaultDescription();
            log.fatal((Object)(failedCheck.getName() + " failed: " + desc));
            log.fatal((Object)"Database startup check failed.");
            EventType eventType = EventType.get((String)"database");
            Event event = new Event(eventType, failedCheck.getHTMLFaultDescription(), EventLevel.get((String)"error"));
            JohnsonEventContainer.get((ServletContext)this.servletContext).addEvent(event);
        }
    }

    @Override
    public void stop() {
    }
}

