/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.config.webwork.WebworkConfigurator;
import com.atlassian.jira.startup.FailedStartupCheck;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.startup.JiraStartupChecklist;
import org.apache.log4j.Logger;

public class ComponentContainerLauncher
implements JiraLauncher {
    private static final Logger log = Logger.getLogger(ComponentContainerLauncher.class);

    @Override
    public void start() {
        try {
            this.populateFullPicoContainer();
        }
        catch (RuntimeException rte) {
            log.fatal((Object)("A RuntimeException occurred during ComponentContainerLauncher servlet context initialisation - " + rte.getMessage() + "."), (Throwable)rte);
            throw rte;
        }
        catch (Error error) {
            log.fatal((Object)("An Error occurred during ComponentContainerLauncher servlet context initialisation - " + error.getMessage() + "."), (Throwable)error);
            throw error;
        }
    }

    private void populateFullPicoContainer() {
        if (JiraStartupChecklist.startupOK()) {
            try {
                ComponentManager componentManager = ComponentManager.getInstance();
                if (componentManager.getState().isContainerInitialised()) {
                    componentManager.shutdown();
                }
                componentManager.initialise();
                WebworkConfigurator.setupConfiguration();
            }
            catch (Exception ex) {
                log.fatal((Object)"A fatal error occurred during initialisation. JIRA has been locked.", (Throwable)ex);
                String message = ex.getMessage() == null ? ex.getClass().getSimpleName() : ex.getMessage();
                JiraStartupChecklist.setFailedStartupCheck(new FailedStartupCheck("Component Manager", message));
            }
        } else {
            log.fatal((Object)"Not initializing JIRA, the startup checklist failed and JIRA has been locked.");
        }
    }

    @Override
    public void stop() {
        ComponentManager.getInstance().dispose();
    }
}

