/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.FailoverProperties;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.startup.JiraClusteringConfigChecklist;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class ClusteringChecklistLauncher
implements JiraLauncher {
    private static final Logger log = Logger.getLogger(ClusteringChecklistLauncher.class);
    private final ServletContext servletContext;

    public ClusteringChecklistLauncher() {
        this.servletContext = ServletContextProvider.getServletContext();
    }

    @VisibleForTesting
    ClusteringChecklistLauncher(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public void start() {
        FailoverProperties failoverProperties;
        ClusterManager clusterManager = (ClusterManager)ComponentAccessor.getComponentOfType(ClusterManager.class);
        JiraClusteringConfigChecklist jiraClusteringConfigChecklist = new JiraClusteringConfigChecklist(clusterManager, failoverProperties = (FailoverProperties)ComponentAccessor.getComponentOfType(FailoverProperties.class));
        if (jiraClusteringConfigChecklist.startupOK()) {
            log.info((Object)"JIRA clustering startup checks completed successfully.");
        } else {
            List<StartupCheck> failedChecks = jiraClusteringConfigChecklist.getFailedStartupChecks();
            for (StartupCheck failedCheck : failedChecks) {
                this.raiseJohnson(failedCheck);
            }
        }
    }

    private void raiseJohnson(StartupCheck failedCheck) {
        String desc = failedCheck.getFaultDescription();
        log.fatal((Object)(failedCheck.getName() + " failed: " + desc));
        log.fatal((Object)"Clustering startup check failed.");
        EventType eventType = EventType.get((String)"clustering");
        Event event = new Event(eventType, failedCheck.getHTMLFaultDescription(), EventLevel.get((String)"error"));
        JohnsonEventContainer.get((ServletContext)this.servletContext).addEvent(event);
    }

    @Override
    public void stop() {
    }
}

