/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.startup.JiraStartupChecklist;
import com.atlassian.jira.startup.JiraStartupLogger;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericDelegator;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class ChecklistLauncher
implements JiraLauncher {
    private static final Logger log = Logger.getLogger(ChecklistLauncher.class);
    private final JiraProperties jiraSystemProperties;

    public ChecklistLauncher(JiraProperties jiraSystemProperties) {
        this.jiraSystemProperties = jiraSystemProperties;
    }

    @Override
    public void start() {
        try {
            this.setJiraDevMode();
            this.setupJiraDefaults();
            this.runStartupChecks(ServletContextProvider.getServletContext());
        }
        catch (RuntimeException rte) {
            log.fatal((Object)("A RuntimeException occurred during ChecklistLauncher initialisation - " + rte.getMessage() + "."), (Throwable)rte);
            throw rte;
        }
        catch (Error error) {
            log.fatal((Object)("An Error occurred during ChecklistLauncher initialisation - " + error.getMessage() + "."), (Throwable)error);
            throw error;
        }
    }

    private void setupJiraDefaults() {
        ImmutableMap defaults = ImmutableMap.builder().put((Object)"plugin.webresource.batching.off", (Object)this.jiraSystemProperties.isDevMode()).build();
        for (Map.Entry entry : defaults.entrySet()) {
            if (this.jiraSystemProperties.getProperty((String)entry.getKey()) != null) continue;
            log.warn((Object)String.format("Setting an unset default variable \"%s\" to: %s", entry.getKey(), entry.getValue()));
            this.jiraSystemProperties.setProperty((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void stop() {
        JiraStartupChecklist.stop();
        this.removeAnyJohnsonEvents();
        this.deleteTemporaryAttachmentsDir();
        SLF4JBridgeHandler.uninstall();
    }

    private void removeAnyJohnsonEvents() {
        JohnsonEventContainer container = JohnsonEventContainer.get((ServletContext)ServletContextProvider.getServletContext());
        Collection events = container.getEvents();
        for (Event event : events) {
            container.removeEvent(event);
        }
    }

    private void runStartupChecks(ServletContext servletContext) {
        JiraStartupLogger.log().info((Object)"Running JIRA startup checks.");
        if (JiraStartupChecklist.startupOK()) {
            JiraStartupLogger.log().info((Object)"JIRA pre-database startup checks completed successfully.");
        } else {
            JiraStartupLogger.log().fatal((Object)"Startup check failed. JIRA will be locked.");
            GenericDelegator.lock();
            Event event = new Event(EventType.get((String)JiraStartupChecklist.getFailedStartupCheck().getName()), JiraStartupChecklist.getFailedStartupCheck().getFaultDescription(), EventLevel.get((String)"error"));
            JohnsonEventContainer.get((ServletContext)servletContext).addEvent(event);
        }
    }

    private void setJiraDevMode() {
        if (this.jiraSystemProperties.isDevMode()) {
            this.setDefault("atlassian.webresource.disable.minification", "true", new String[0]);
            this.setDefault("atlassian.mail.senddisabled", "true", new String[0]);
            this.setDefault("atlassian.mail.fetchdisabled", "true", "atlassian.mail.popdisabled");
            this.setDefault("com.atlassian.gadgets.dashboard.ignoreCache", "true", new String[0]);
            this.setDefault("atlassian.disable.caches", "true", new String[0]);
            this.setDefault("jira.jelly.on", "true", new String[0]);
            this.setDefault("atlassian.dev.mode", "true", new String[0]);
            this.setDefault("jira.websudo.is.disabled", "true", new String[0]);
            this.setDefault("jira.i18n.reloadbundles", "true", new String[0]);
        }
    }

    private void setDefault(String key, String value, String ... relatedKeys) {
        if (this.jiraSystemProperties.getProperty(key) != null) {
            log.debug((Object)("Trying to set already defined system property '" + key + "' to '" + value + "' because development mode is on. Leaving as current value '" + this.jiraSystemProperties.getProperty(key) + "'."));
            return;
        }
        if (relatedKeys != null) {
            for (String relatedKey : relatedKeys) {
                String sysVal = this.jiraSystemProperties.getProperty(relatedKey);
                if (sysVal == null) continue;
                String mesg = "Trying to set system property '" + key + "' to '" + value + "' because development mode is on. But related property '" + relatedKey + "' is already set to '" + sysVal + "'. So not setting.";
                if (sysVal.equals(value)) {
                    log.debug((Object)mesg);
                } else {
                    log.warn((Object)mesg);
                }
                return;
            }
        }
        log.info((Object)("Setting system property '" + key + "' to '" + value + "' for development mode."));
        this.jiraSystemProperties.setProperty(key, (Object)value);
    }

    private void deleteTemporaryAttachmentsDir() {
        try {
            File attachmentDirectory = AttachmentUtils.getTemporaryAttachmentDirectory();
            try {
                FileUtils.deleteDirectory((File)attachmentDirectory);
            }
            catch (IOException ioException) {
                log.warn((Object)("Warning: (" + ioException.getMessage() + ") deleting temporary attachments directory '" + attachmentDirectory + "' on shutdown. Ignoring since this is not required."), (Throwable)ioException);
            }
        }
        catch (Exception tempAttachmentsDirectoryNotRemovedException) {
            log.warn((Object)"Couldn't delete the temporary attachments directory.", (Throwable)tempAttachmentsDirectoryNotRemovedException);
        }
    }
}

