/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.search.ProjectShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.ProjectShareType;
import com.atlassian.jira.sharing.type.ShareTypeValidator;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;

public class ProjectShareTypeValidator
implements ShareTypeValidator {
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final ProjectRoleManager projectRoleManager;

    public ProjectShareTypeValidator(PermissionManager permissionManager, ProjectManager projectManager, ProjectRoleManager projectRoleManager) {
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.projectRoleManager = projectRoleManager;
    }

    public boolean checkSharePermission(JiraServiceContext ctx, SharePermission permission) {
        Assertions.notNull((String)"ctx", (Object)ctx);
        Assertions.notNull((String)"ctx.user", (Object)ctx.getLoggedInApplicationUser());
        Assertions.notNull((String)"permission", (Object)permission);
        Assertions.equals((String)ProjectShareType.TYPE.toString(), (Object)ProjectShareType.TYPE, (Object)permission.getType());
        boolean hasPermission = this.permissionManager.hasPermission(22, ctx.getLoggedInApplicationUser());
        if (!hasPermission) {
            ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.no.share.permission"));
            ctx.getErrorCollection().addError("shares_delegated", ctx.getI18nBean().getText("common.sharing.exception.delegated.user.no.share.permission", ctx.getLoggedInApplicationUser().getDisplayName()));
        } else {
            Long projectId;
            try {
                projectId = new Long(permission.getParam1());
            }
            catch (NumberFormatException e) {
                String perm = permission.getParam1() == null ? "" : permission.getParam1();
                ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.project.id.not.valid", perm));
                return false;
            }
            Project project = this.projectManager.getProjectObj(projectId);
            if (project == null) {
                ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.project.does.not.exist"));
            } else if (permission.getParam2() == null) {
                if (!this.permissionManager.hasPermission(10, project, ctx.getLoggedInApplicationUser())) {
                    ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.no.permission.project", project.getName()));
                    ctx.getErrorCollection().addError("shares_delegated", ctx.getI18nBean().getText("common.sharing.exception.delegated.user.no.permission.project", ctx.getLoggedInApplicationUser().getDisplayName(), project.getName()));
                }
            } else {
                Long roleId;
                try {
                    roleId = new Long(permission.getParam2());
                }
                catch (NumberFormatException e) {
                    String perm = permission.getParam2() == null ? "" : permission.getParam2();
                    ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.role.id.not.valid", perm));
                    return false;
                }
                ProjectRole role = this.projectRoleManager.getProjectRole(roleId);
                if (role == null) {
                    ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.role.does.not.exist"));
                } else if (!this.permissionManager.hasPermission(10, project, ctx.getLoggedInApplicationUser())) {
                    ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.no.permission.project.but.in.role", project.getName()));
                    ctx.getErrorCollection().addError("shares_delegated", ctx.getI18nBean().getText("common.sharing.exception.delegated.user.no.permission.project.but.in.role", ctx.getLoggedInApplicationUser().getDisplayName(), project.getName()));
                } else if (!this.projectRoleManager.isUserInProjectRole(ctx.getLoggedInApplicationUser(), role, project)) {
                    ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.no.permission.role", project.getName(), role.getName()));
                    ctx.getErrorCollection().addError("shares_delegated", ctx.getI18nBean().getText("common.sharing.exception.delegated.user.no.permission.role", ctx.getLoggedInApplicationUser().getDisplayName(), project.getName(), role.getName()));
                }
            }
        }
        return !ctx.getErrorCollection().hasAnyErrors();
    }

    public boolean checkSearchParameter(JiraServiceContext serviceCtx, ShareTypeSearchParameter searchParameter) {
        Assertions.notNull((String)"serviceCtx", (Object)serviceCtx);
        Assertions.notNull((String)"searchParameter", (Object)searchParameter);
        Assertions.equals((String)ProjectShareType.TYPE.toString(), (Object)ProjectShareType.TYPE, (Object)searchParameter.getType());
        ProjectShareTypeSearchParameter projectShareTypeSearchParameter = (ProjectShareTypeSearchParameter)searchParameter;
        ErrorCollection errorCollection = serviceCtx.getErrorCollection();
        I18nHelper i18nHelper = serviceCtx.getI18nBean();
        Long projectId = projectShareTypeSearchParameter.getProjectId();
        Long roleId = projectShareTypeSearchParameter.getRoleId();
        if (projectId != null) {
            Project project = this.projectManager.getProjectObj(projectId);
            if (project == null) {
                errorCollection.addError("shares", i18nHelper.getText("common.sharing.searching.exception.project.does.not.exist", (Object)projectId));
            } else if (roleId != null) {
                ProjectRole projectRole = this.projectRoleManager.getProjectRole(roleId);
                if (projectRole == null) {
                    errorCollection.addError("shares", i18nHelper.getText("common.sharing.searching.exception.project.role.does.not.exist", (Object)roleId));
                } else if (!this.projectRoleManager.isUserInProjectRole(serviceCtx.getLoggedInApplicationUser(), projectRole, project)) {
                    errorCollection.addError("shares", i18nHelper.getText("common.sharing.searching.exception.user.not.in.project.role"));
                }
            } else {
                boolean browsePermission = this.permissionManager.hasPermission(10, project, serviceCtx.getLoggedInApplicationUser());
                if (!browsePermission) {
                    errorCollection.addError("shares", i18nHelper.getText("common.sharing.searching.exception.project.no.browse.permission"));
                }
            }
        }
        return !errorCollection.hasAnyErrors();
    }
}

