/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servlet;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.web.action.admin.GeneralConfigurationUpdatedEvent;
import com.atlassian.jira.servlet.JiraCaptchaService;
import com.atlassian.jira.servlet.JiraImageCaptchaServiceImpl;
import com.atlassian.jira.servlet.NoOpCaptchaServiceImpl;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.octo.captcha.service.image.ImageCaptchaService;

@EventComponent
public final class JiraCaptchaServiceImpl
implements JiraCaptchaService {
    private static ResettableLazyReference<JiraCaptchaService> delegate = new ResettableLazyReference<JiraCaptchaService>(){

        protected JiraCaptchaService create() throws Exception {
            FeatureManager featureManager = (FeatureManager)ComponentAccessor.getComponentOfType(FeatureManager.class);
            boolean shouldUseCaptcha = JiraCaptchaServiceImpl.publicSignup();
            if (featureManager.isOnDemand() && !shouldUseCaptcha) {
                return new NoOpCaptchaServiceImpl();
            }
            return new JiraImageCaptchaServiceImpl();
        }
    };

    public JiraCaptchaServiceImpl() {
        delegate.reset();
    }

    private static boolean publicSignup() {
        ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
        return "public".equals(applicationProperties.getString("jira.mode")) && applicationProperties.getOption("jira.option.captcha.on.signup");
    }

    public static ImageCaptchaService getInstance() {
        return ((JiraCaptchaService)delegate.get()).getImageCaptchaService();
    }

    @Override
    public ImageCaptchaService getImageCaptchaService() {
        return JiraCaptchaServiceImpl.getInstance();
    }

    @EventListener
    public void onGeneralConfigurationChange(GeneralConfigurationUpdatedEvent event) {
        delegate.reset();
    }
}

