/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.xsrf;

import com.atlassian.jira.bc.license.JiraServerIdProvider;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.atlassian.security.utils.ConstantTimeComparison;
import com.opensymphony.util.TextUtils;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class SimpleXsrfTokenGenerator
implements XsrfTokenGenerator {
    private static final String SET_COOKIE_PENDING = "jira.xsrf.set.cookie.pending";
    private static final String LOGGED_IN = "lin";
    private static final String LOGGED_OUT = "lout";
    private final JiraAuthenticationContext authenticationContext;
    private final JiraServerIdProvider jiraServerIdProvider;

    public SimpleXsrfTokenGenerator(JiraAuthenticationContext authenticationContext, JiraServerIdProvider jiraServerIdProvider) {
        this.authenticationContext = authenticationContext;
        this.jiraServerIdProvider = jiraServerIdProvider;
    }

    public String generateToken(HttpServletRequest httpServletRequest) {
        return this.generateTokenImpl(httpServletRequest, true);
    }

    public String generateToken(HttpServletRequest httpServletRequest, boolean create) {
        return this.generateTokenImpl(httpServletRequest, create);
    }

    public String generateToken(VelocityRequestContext request) {
        return this.generateTokenImpl(null, true);
    }

    public String generateToken() {
        return this.generateTokenImpl(null, true);
    }

    public String generateToken(boolean create) {
        return this.generateTokenImpl(null, create);
    }

    public String getXsrfTokenName() {
        return "atlassian.xsrf.token";
    }

    public boolean validateToken(HttpServletRequest httpServletRequest, String token) {
        if (token != null && httpServletRequest != null) {
            String pendingToken = this.getPendingToken(httpServletRequest);
            String storedToken = this.getXsrfCookie(httpServletRequest, pendingToken);
            return ConstantTimeComparison.isEqual((String)token, (String)storedToken);
        }
        return false;
    }

    public boolean generatedByAuthenticatedUser(String token) {
        return StringUtils.isNotBlank((String)token) && token.endsWith("|lin");
    }

    private String generateTokenImpl(HttpServletRequest httpServletRequest, boolean create) {
        HttpServletRequest safeHttpServletRequest = this.safeAccess(httpServletRequest);
        if (null == safeHttpServletRequest) {
            return null;
        }
        String pendingToken = this.getPendingToken(safeHttpServletRequest);
        if (StringUtils.isNotBlank((String)pendingToken)) {
            return pendingToken;
        }
        boolean thereIsAnAuthenticatedUser = this.authenticationContext.getLoggedInUser() != null;
        String token = this.getToken(safeHttpServletRequest);
        if (create && !this.isValidServerSideToken(token, thereIsAnAuthenticatedUser)) {
            return this.setXsrfCookie(safeHttpServletRequest, this.createToken(thereIsAnAuthenticatedUser));
        }
        return token;
    }

    private boolean isValidServerSideToken(String token, boolean thereIsAnAuthenticatedUser) {
        if (token != null) {
            if (!this.isOurServerId(token)) {
                return false;
            }
            if (this.generatedByAuthenticatedUser(token)) {
                return thereIsAnAuthenticatedUser;
            }
            return !thereIsAnAuthenticatedUser;
        }
        return false;
    }

    public String getToken(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"atlassian.xsrf.token".equalsIgnoreCase(cookie.getName())) continue;
                return TextUtils.htmlEncode((String)cookie.getValue());
            }
        }
        return null;
    }

    private String getXsrfCookie(HttpServletRequest httpServletRequest, String pendingToken) {
        if (StringUtils.isNotBlank((String)pendingToken)) {
            return pendingToken;
        }
        return this.getToken(httpServletRequest);
    }

    private String setXsrfCookie(HttpServletRequest httpServletRequest, String token) {
        HttpServletResponse httpServletResponse = ExecutingHttpRequest.getResponse();
        if (httpServletResponse != null) {
            this.addNewCookie(httpServletRequest, token, httpServletResponse);
        }
        return token;
    }

    private void addNewCookie(HttpServletRequest httpServletRequest, String token, HttpServletResponse httpServletResponse) {
        Cookie cookie = new Cookie("atlassian.xsrf.token", token);
        cookie.setPath(this.getRequestContext(httpServletRequest));
        cookie.setMaxAge(-1);
        cookie.setSecure(httpServletRequest.isSecure());
        httpServletResponse.addCookie(cookie);
        httpServletRequest.setAttribute(SET_COOKIE_PENDING, (Object)token);
    }

    private String getRequestContext(HttpServletRequest httpServletRequest) {
        String contextPath = httpServletRequest.getContextPath();
        return StringUtils.isBlank((String)contextPath) ? "/" : contextPath;
    }

    private String getPendingToken(HttpServletRequest httpServletRequest) {
        return (String)httpServletRequest.getAttribute(SET_COOKIE_PENDING);
    }

    private boolean isOurServerId(String token) {
        StringTokenizer st = new StringTokenizer(token, "|");
        return StringUtils.defaultString((String)this.jiraServerIdProvider.getServerId()).equals(st.nextToken());
    }

    private String createToken(boolean thereIsAnAuthenticatedUser) {
        String serverId = this.jiraServerIdProvider.getServerId();
        String crytoPart = DefaultSecureTokenGenerator.getInstance().generateToken();
        return serverId + "|" + crytoPart + "|" + (thereIsAnAuthenticatedUser ? LOGGED_IN : LOGGED_OUT);
    }

    private HttpServletRequest safeAccess(HttpServletRequest httpServletRequest) {
        return httpServletRequest != null ? httpServletRequest : ExecutingHttpRequest.get();
    }
}

