/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.type.SimpleIssueFieldSecurityType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;

public class CurrentAssigneeHasAssignablePermission
extends SimpleIssueFieldSecurityType {
    private JiraAuthenticationContext authenticationContext;

    public CurrentAssigneeHasAssignablePermission(JiraAuthenticationContext jiraAuthenticationContext) {
        this.authenticationContext = jiraAuthenticationContext;
    }

    @Override
    public String getDisplayName() {
        return this.authenticationContext.getI18nHelper().getText("admin.permission.types.current.assignee.has.assignable.perm");
    }

    @Override
    public String getType() {
        return "assigneeassignable";
    }

    public void doValidation(String key, Map parameters, JiraServiceContext jiraServiceContext) {
    }

    @Override
    protected String getFieldName(String parameter) {
        return "issue_assignee";
    }

    @Override
    public boolean isValidForPermission(int permissionId) {
        return permissionId != 17;
    }

    @Override
    protected boolean hasProjectPermission(User user, boolean issueCreation, GenericValue project) {
        return this.getPermissionManager().hasPermission(17, project, user, issueCreation);
    }

    @Override
    protected boolean hasProjectPermission(User user, boolean issueCreation, Project project) {
        return this.getPermissionManager().hasPermission(17, project, user, issueCreation);
    }

    @VisibleForTesting
    PermissionManager getPermissionManager() {
        return ComponentAccessor.getPermissionManager();
    }

    @Override
    protected String getField() {
        return "assignee";
    }

    @Override
    public Set<User> getUsers(PermissionContext ctx, String ignored) {
        Issue issue = ctx.getIssue();
        if (issue != null && issue.getAssignee() != null && this.getPermissionManager().hasPermission(17, issue.getAssignee())) {
            return Sets.newHashSet((Object[])new User[]{issue.getAssignee()});
        }
        return Sets.newHashSet();
    }

    @Override
    protected String getFieldValue(Issue issue) {
        return issue.getAssigneeId();
    }
}

