/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles.actor;

import com.atlassian.annotations.Internal;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorDoesNotExistException;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.security.roles.actor.AbstractRoleActor;
import com.atlassian.jira.user.ApplicationUser;
import java.util.HashSet;
import java.util.Set;

@Internal
public class GroupRoleActorFactory
implements RoleActorFactory {
    public static final String TYPE = "atlassian-group-role-actor";
    private final GroupManager groupManager;

    public GroupRoleActorFactory(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    public ProjectRoleActor createRoleActor(Long id, Long projectRoleId, Long projectId, String type, String groupName) throws RoleActorDoesNotExistException {
        if (!TYPE.equals(type)) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot create RoleActors of type: " + type);
        }
        Group group = this.groupManager.getGroupEvenWhenUnknown(groupName);
        return new GroupRoleActor(id, projectRoleId, projectId, group, this.groupManager.groupExists(groupName));
    }

    public Set<RoleActor> optimizeRoleActorSet(Set<RoleActor> roleActors) {
        return roleActors;
    }

    public class GroupRoleActor
    extends AbstractRoleActor {
        private final Group group;
        private final boolean active;

        GroupRoleActor(Long id, Long projectRoleId, Long projectId, Group group, boolean active) {
            super(id, projectRoleId, projectId, group.getName());
            this.group = group;
            this.active = active;
        }

        public boolean isActive() {
            return this.active;
        }

        public String getType() {
            return GroupRoleActorFactory.TYPE;
        }

        public String getDescriptor() {
            return this.getParameter();
        }

        public Set<User> getUsers() {
            HashSet<User> users = new HashSet<User>();
            for (User user : GroupRoleActorFactory.this.groupManager.getUsersInGroup(this.group.getName())) {
                users.add(user);
            }
            return users;
        }

        public boolean contains(ApplicationUser user) {
            return user != null && GroupRoleActorFactory.this.groupManager.isUserInGroup(user.getDirectoryUser(), this.group);
        }

        public boolean contains(User user) {
            return user != null && GroupRoleActorFactory.this.groupManager.isUserInGroup(user, this.group);
        }

        public Group getGroup() throws IllegalArgumentException {
            return this.group;
        }
    }
}

