/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleAndActorStore;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.Immutable;

@EventComponent
public class CachingProjectRoleAndActorStore
implements ProjectRoleAndActorStore {
    private final ProjectRoleAndActorStore delegate;
    private final RoleActorFactory roleActorFactory;
    final CachedReference<AllProjectRoles> projectRoles;
    final Cache<Long, CacheObject<CachedRoleActors>> defaultRoleActors;
    final Cache<ProjectRoleActorsKey, CacheObject<CachedRoleActors>> projectRoleActors;

    public CachingProjectRoleAndActorStore(ProjectRoleAndActorStore delegate, RoleActorFactory roleActorFactory, CacheManager cacheManager) {
        this.delegate = delegate;
        this.roleActorFactory = roleActorFactory;
        this.projectRoles = cacheManager.getCachedReference(this.getClass(), "projectRoles", (Supplier)new AllProjectRolesLoader());
        this.defaultRoleActors = cacheManager.getCache(this.getClass().getName() + ".defaultRoleActors", (CacheLoader)new DefaultRoleActorsLoader());
        this.projectRoleActors = cacheManager.getCache(this.getClass().getName() + ".projectRoleActors", (CacheLoader)new ProjectRoleActorsLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    @Override
    public Collection<ProjectRole> getAllProjectRoles() {
        return ((AllProjectRoles)this.projectRoles.get()).getAll();
    }

    @Override
    public ProjectRole getProjectRole(Long id) {
        return ((AllProjectRoles)this.projectRoles.get()).get(id);
    }

    @Override
    public ProjectRole getProjectRoleByName(String name) {
        return ((AllProjectRoles)this.projectRoles.get()).getByName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectRole addProjectRole(ProjectRole projectRole) {
        try {
            ProjectRole projectRole2 = this.delegate.addProjectRole(projectRole);
            return projectRole2;
        }
        finally {
            this.projectRoles.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateProjectRole(ProjectRole projectRole) {
        try {
            this.delegate.updateProjectRole(projectRole);
        }
        finally {
            this.projectRoles.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteProjectRole(ProjectRole projectRole) {
        long projectRoleId = (Long)Assertions.notNull((String)"projectRole.getId()", (Object)((ProjectRole)Assertions.notNull((String)"projectRole", (Object)projectRole)).getId());
        try {
            this.delegate.deleteProjectRole(projectRole);
        }
        finally {
            this.projectRoles.reset();
            this.defaultRoleActors.remove((Object)projectRoleId);
            for (ProjectRoleActorsKey key : this.projectRoleActors.getKeys()) {
                if (projectRoleId != key.getProjectRoleId()) continue;
                this.projectRoleActors.remove((Object)key);
            }
        }
    }

    @Override
    public DefaultRoleActors getDefaultRoleActors(Long projectRoleId) {
        return (DefaultRoleActors)((CacheObject)this.defaultRoleActors.get((Object)projectRoleId)).getValue();
    }

    @Override
    public ProjectRoleActors getProjectRoleActors(Long projectRoleId, Long projectId) {
        if (projectId == null) {
            return (ProjectRoleActors)((CacheObject)this.defaultRoleActors.get(Assertions.notNull((String)"projectRoleId", (Object)projectRoleId))).getValue();
        }
        return (ProjectRoleActors)((CacheObject)this.projectRoleActors.get((Object)CachingProjectRoleAndActorStore.toKey(projectRoleId, projectId))).getValue();
    }

    @Override
    public void updateProjectRoleActors(ProjectRoleActors projectRoleActors) {
        if (projectRoleActors.getProjectId() == null) {
            this.updateDefaultRoleActors((DefaultRoleActors)projectRoleActors);
            return;
        }
        this.delegate.updateProjectRoleActors(projectRoleActors);
        this.projectRoleActors.remove((Object)CachingProjectRoleAndActorStore.toKey(projectRoleActors));
    }

    @Override
    public void updateDefaultRoleActors(DefaultRoleActors defaultRoleActors) {
        this.delegate.updateDefaultRoleActors(defaultRoleActors);
        this.defaultRoleActors.remove((Object)defaultRoleActors.getProjectRoleId());
    }

    @Override
    public void applyDefaultsRolesToProject(Project project) {
        this.delegate.applyDefaultsRolesToProject(project);
    }

    @Override
    public void removeAllRoleActorsByKeyAndType(String key, String type) {
        this.delegate.removeAllRoleActorsByKeyAndType(key, type);
        this.defaultRoleActors.removeAll();
        this.projectRoleActors.removeAll();
    }

    @Override
    public void removeAllRoleActorsByProject(Project project) {
        this.delegate.removeAllRoleActorsByProject(project);
        long projectId = project.getId();
        for (ProjectRoleActorsKey key : this.projectRoleActors.getKeys()) {
            if (projectId != key.getProjectId()) continue;
            this.projectRoleActors.remove((Object)key);
        }
    }

    @Override
    public Collection<Long> getProjectIdsContainingRoleActorByKeyAndType(String key, String type) {
        return this.delegate.getProjectIdsContainingRoleActorByKeyAndType(key, type);
    }

    @Override
    public List<Long> roleActorOfTypeExistsForProjects(List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String projectRoleParameter) {
        return this.delegate.roleActorOfTypeExistsForProjects(projectsToLimitBy, projectRole, projectRoleType, projectRoleParameter);
    }

    @Override
    public Map<Long, List<String>> getProjectIdsForUserInGroupsBecauseOfRole(List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String userKey) {
        return this.delegate.getProjectIdsForUserInGroupsBecauseOfRole(projectsToLimitBy, projectRole, projectRoleType, userKey);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCaches();
    }

    public void clearCaches() {
        this.projectRoles.reset();
        this.defaultRoleActors.removeAll();
        this.projectRoleActors.removeAll();
    }

    static ProjectRoleActorsKey toKey(Long projectRoleId, Long projectId) {
        return new ProjectRoleActorsKey(projectRoleId, projectId);
    }

    static ProjectRoleActorsKey toKey(ProjectRoleActors projectRoleActors) {
        return CachingProjectRoleAndActorStore.toKey(projectRoleActors.getProjectRoleId(), projectRoleActors.getProjectId());
    }

    CacheObject<CachedRoleActors> toCacheObject(DefaultRoleActors defaultRoleActors) {
        if (defaultRoleActors == null) {
            return CacheObject.NULL();
        }
        Set optimizedRoleActors = this.roleActorFactory.optimizeRoleActorSet(defaultRoleActors.getRoleActors());
        return CacheObject.wrap(new CachedRoleActors(defaultRoleActors, optimizedRoleActors));
    }

    static class CachedRoleActors
    implements ProjectRoleActors {
        private final DefaultRoleActors delegate;
        private final Set<RoleActor> optimizedProjectRoleSet;

        CachedRoleActors(DefaultRoleActors delegate, Set<RoleActor> optimizedProjectRoleSet) {
            this.delegate = delegate;
            this.optimizedProjectRoleSet = ImmutableSet.copyOf(optimizedProjectRoleSet);
        }

        public boolean contains(ApplicationUser user) {
            for (RoleActor o : this.optimizedProjectRoleSet) {
                if (!o.contains(user)) continue;
                return true;
            }
            return false;
        }

        public boolean contains(User user) {
            return this.contains(ApplicationUsers.from((User)user));
        }

        public Long getProjectId() {
            return this.delegate instanceof ProjectRoleActors ? ((ProjectRoleActors)this.delegate).getProjectId() : null;
        }

        public Set<User> getUsers() {
            return this.delegate.getUsers();
        }

        public Set<ApplicationUser> getApplicationUsers() {
            return this.delegate.getApplicationUsers();
        }

        public Set<RoleActor> getRoleActors() {
            return this.delegate.getRoleActors();
        }

        public Long getProjectRoleId() {
            return this.delegate.getProjectRoleId();
        }

        public Set<RoleActor> getRoleActorsByType(String type) {
            return this.delegate.getRoleActorsByType(type);
        }

        public DefaultRoleActors addRoleActors(Collection<? extends RoleActor> roleActors) {
            return this.delegate.addRoleActors(roleActors);
        }

        public DefaultRoleActors addRoleActor(RoleActor roleActor) {
            return this.delegate.addRoleActor(roleActor);
        }

        public DefaultRoleActors removeRoleActor(RoleActor roleActor) {
            return this.delegate.removeRoleActor(roleActor);
        }

        public DefaultRoleActors removeRoleActors(Collection<? extends RoleActor> roleActors) {
            return this.delegate.removeRoleActors(roleActors);
        }

        public String toString() {
            return "CachedRoleActors[delegate=" + this.delegate + ",optimizedProjectRoleSet=" + this.optimizedProjectRoleSet + ']';
        }
    }

    static class AllProjectRoles {
        private final List<ProjectRole> projectRoles;
        private final Map<Long, ProjectRole> projectRolesById;
        private final Map<String, ProjectRole> projectRolesByName;

        AllProjectRoles(Collection<ProjectRole> projectRoles) {
            ImmutableMap.Builder byId = ImmutableMap.builder();
            ImmutableMap.Builder byName = ImmutableMap.builder();
            for (ProjectRole projectRole : projectRoles) {
                byId.put((Object)projectRole.getId(), (Object)projectRole);
                byName.put((Object)projectRole.getName(), (Object)projectRole);
            }
            this.projectRoles = ImmutableList.copyOf(projectRoles);
            this.projectRolesById = byId.build();
            this.projectRolesByName = byName.build();
        }

        Collection<ProjectRole> getAll() {
            return this.projectRoles;
        }

        ProjectRole get(Long id) {
            return this.projectRolesById.get(id);
        }

        ProjectRole getByName(String name) {
            return this.projectRolesByName.get(name);
        }
    }

    @Immutable
    static final class ProjectRoleActorsKey {
        final long projectRoleId;
        final long projectId;

        ProjectRoleActorsKey(Long projectRoleId, Long projectId) {
            this.projectRoleId = (Long)Assertions.notNull((String)"projectRoleId", (Object)projectRoleId);
            this.projectId = (Long)Assertions.notNull((String)"projectId", (Object)projectId);
        }

        public long getProjectRoleId() {
            return this.projectRoleId;
        }

        public long getProjectId() {
            return this.projectId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectRoleActorsKey other = (ProjectRoleActorsKey)o;
            return this.projectRoleId == other.projectRoleId && this.projectId == other.projectId;
        }

        public int hashCode() {
            long value = this.projectId * 31L + this.projectRoleId;
            return (int)(value ^ value >>> 32);
        }

        public String toString() {
            return "ProjectRoleActorsKey[projectRoleId=" + this.projectRoleId + ",projectId=" + this.projectId + ']';
        }
    }

    class AllProjectRolesLoader
    implements Supplier<AllProjectRoles> {
        AllProjectRolesLoader() {
        }

        public AllProjectRoles get() {
            return new AllProjectRoles(CachingProjectRoleAndActorStore.this.delegate.getAllProjectRoles());
        }
    }

    class ProjectRoleActorsLoader
    implements CacheLoader<ProjectRoleActorsKey, CacheObject<CachedRoleActors>> {
        ProjectRoleActorsLoader() {
        }

        public CacheObject<CachedRoleActors> load(@NotNull ProjectRoleActorsKey key) {
            return CachingProjectRoleAndActorStore.this.toCacheObject((DefaultRoleActors)CachingProjectRoleAndActorStore.this.delegate.getProjectRoleActors(key.getProjectRoleId(), key.getProjectId()));
        }
    }

    class DefaultRoleActorsLoader
    implements CacheLoader<Long, CacheObject<CachedRoleActors>> {
        DefaultRoleActorsLoader() {
        }

        public CacheObject<CachedRoleActors> load(@NotNull Long projectRoleId) {
            return CachingProjectRoleAndActorStore.this.toCacheObject(CachingProjectRoleAndActorStore.this.delegate.getDefaultRoleActors(projectRoleId));
        }
    }
}

