/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.plugin;

import com.atlassian.event.api.EventListener;
import com.atlassian.fugue.Option;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.permission.GlobalPermissionType;
import com.atlassian.jira.plugin.permission.GlobalPermissionModuleDescriptor;
import com.atlassian.jira.security.plugin.GlobalPermissionTypesManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.atlassian.util.concurrent.NotNull;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@EventComponent
public class GlobalPermissionTypesManagerImpl
implements Startable,
GlobalPermissionTypesManager {
    private final DefaultPluginModuleTracker<Void, GlobalPermissionModuleDescriptor> pluginModuleTracker;
    private final ResettableLazyReference<Map<String, GlobalPermissionType>> globalPermissions;

    public GlobalPermissionTypesManagerImpl(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        this.pluginModuleTracker = new DefaultPluginModuleTracker(pluginAccessor, pluginEventManager, GlobalPermissionModuleDescriptor.class, (PluginModuleTracker.Customizer)new PluginModuleTracker.Customizer<Void, GlobalPermissionModuleDescriptor>(){

            public void removed(GlobalPermissionModuleDescriptor descriptor) {
                GlobalPermissionTypesManagerImpl.this.globalPermissions.reset();
            }

            public GlobalPermissionModuleDescriptor adding(GlobalPermissionModuleDescriptor descriptor) {
                GlobalPermissionTypesManagerImpl.this.globalPermissions.reset();
                return descriptor;
            }
        });
        this.globalPermissions = new ResettableLazyReference<Map<String, GlobalPermissionType>>(){

            protected Map<String, GlobalPermissionType> create() {
                HashMap permissions = Maps.newHashMap();
                for (GlobalPermissionModuleDescriptor moduleDescriptor : GlobalPermissionTypesManagerImpl.this.pluginModuleTracker.getModuleDescriptors()) {
                    GlobalPermissionType globalPermissionType = GlobalPermissionTypesManagerImpl.this.createGlobalPermission(moduleDescriptor);
                    permissions.put(moduleDescriptor.getKey(), globalPermissionType);
                }
                return permissions;
            }
        };
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.globalPermissions.reset();
    }

    public void start() throws Exception {
        this.globalPermissions.reset();
    }

    @Override
    public Collection<GlobalPermissionType> getAll() {
        return ((Map)this.globalPermissions.get()).values();
    }

    @Override
    public Option<GlobalPermissionType> getGlobalPermission(@NotNull String permissionKey) {
        return Option.option(((Map)this.globalPermissions.get()).get(permissionKey));
    }

    private GlobalPermissionType createGlobalPermission(GlobalPermissionModuleDescriptor descriptor) {
        return new GlobalPermissionType(descriptor.getKey(), descriptor.getI18nNameKey(), descriptor.getDescriptionI18nKey(), descriptor.isAnonymousAllowed());
    }

    @VisibleForTesting
    DefaultPluginModuleTracker<Void, GlobalPermissionModuleDescriptor> getPluginModuleTracker() {
        return this.pluginModuleTracker;
    }
}

