/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationInfo;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationManager;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@EventComponent
public final class CachingTrustedApplicationManager
implements TrustedApplicationManager {
    private final TrustedApplicationManager delegate;
    private final CachedReference<Cache> cache;

    public CachingTrustedApplicationManager(final TrustedApplicationManager delegate, CacheManager cacheManager) {
        this.delegate = delegate;
        this.cache = cacheManager.getCachedReference(this.getClass(), "cache", (Supplier)new Supplier<Cache>(){

            public Cache get() {
                return new Cache(delegate.getAll());
            }
        });
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.reset();
    }

    @Override
    public Set<TrustedApplicationInfo> getAll() {
        return ((Cache)this.cache.get()).getAll();
    }

    @Override
    public TrustedApplicationInfo get(String applicationId) {
        return ((Cache)this.cache.get()).get(applicationId);
    }

    @Override
    public TrustedApplicationInfo get(long id) {
        return ((Cache)this.cache.get()).get(id);
    }

    @Override
    public boolean delete(User user, long id) {
        boolean result = this.delegate.delete(user, id);
        this.cache.reset();
        return result;
    }

    @Override
    public boolean delete(User user, String applicationId) {
        boolean result = this.delegate.delete(user, applicationId);
        this.cache.reset();
        return result;
    }

    @Override
    public TrustedApplicationInfo store(User user, TrustedApplicationInfo info) {
        TrustedApplicationInfo result = this.delegate.store(user, info);
        this.cache.reset();
        return result;
    }

    @Override
    public TrustedApplicationInfo store(String user, TrustedApplicationInfo info) {
        TrustedApplicationInfo result = this.delegate.store(user, info);
        this.cache.reset();
        return result;
    }

    private static final class Cache {
        final Map<Long, TrustedApplicationInfo> byId;
        final Map<String, TrustedApplicationInfo> byAppId;

        Cache(Set<TrustedApplicationInfo> infos) {
            HashMap byId = Maps.newHashMap();
            HashMap byAppId = Maps.newHashMap();
            for (TrustedApplicationInfo info : infos) {
                byId.put(info.getNumericId(), info);
                byAppId.put(info.getID(), info);
            }
            this.byId = Collections.unmodifiableMap(byId);
            this.byAppId = Collections.unmodifiableMap(byAppId);
        }

        TrustedApplicationInfo get(long id) {
            return this.byId.get(id);
        }

        TrustedApplicationInfo get(String applicationId) {
            return this.byAppId.get(applicationId);
        }

        Set<TrustedApplicationInfo> getAll() {
            return ImmutableSet.copyOf(this.byId.values());
        }
    }
}

