/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.WorkflowPermission;
import com.atlassian.jira.permission.WorkflowPermissionFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.DefaultPermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class WorkflowBasedPermissionManager
extends DefaultPermissionManager {
    private static final Logger log = Logger.getLogger(WorkflowBasedPermissionManager.class);
    private final WorkflowPermissionFactory workflowPermissionFactory;
    private final PermissionContextFactory permissionContextFactory;

    public WorkflowBasedPermissionManager(WorkflowPermissionFactory workflowPermissionFactory, PermissionContextFactory permissionContextFactory) {
        this.workflowPermissionFactory = workflowPermissionFactory;
        this.permissionContextFactory = permissionContextFactory;
    }

    @Override
    public boolean hasPermission(int permissionId, GenericValue projectOrIssue, User user) {
        boolean permSchemeAllows = super.hasPermission(permissionId, projectOrIssue, user);
        return this.workflowPermissionCheck(permSchemeAllows, permissionId, projectOrIssue, user);
    }

    @Override
    public boolean hasPermission(int permissionsId, Issue issue, User user) {
        boolean permSchemeAllows = super.hasPermission(permissionsId, issue, user);
        return this.workflowPermissionCheck(permSchemeAllows, permissionsId, issue.getGenericValue(), user);
    }

    @Override
    public boolean hasPermission(int permissionsId, Issue issue, ApplicationUser user) {
        boolean permSchemeAllows = super.hasPermission(permissionsId, issue, user);
        return this.workflowPermissionCheck(permSchemeAllows, permissionsId, issue.getGenericValue(), ApplicationUsers.toDirectoryUser((ApplicationUser)user));
    }

    @Override
    public boolean hasPermission(int permissionsId, Project project, User user) {
        boolean permSchemeAllows = super.hasPermission(permissionsId, project, user);
        return this.workflowPermissionCheck(permSchemeAllows, permissionsId, project.getGenericValue(), user);
    }

    @Override
    public boolean hasPermission(int permissionsId, Project project, ApplicationUser user) {
        boolean permSchemeAllows = super.hasPermission(permissionsId, project, user);
        return this.workflowPermissionCheck(permSchemeAllows, permissionsId, project.getGenericValue(), ApplicationUsers.toDirectoryUser((ApplicationUser)user));
    }

    @Override
    public boolean hasPermission(int permissionsId, Project project, User user, boolean issueCreation) {
        boolean permSchemeAllows = super.hasPermission(permissionsId, project, user, issueCreation);
        return this.workflowPermissionCheck(permSchemeAllows, permissionsId, project.getGenericValue(), user);
    }

    @Override
    public boolean hasPermission(int permissionsId, Project project, ApplicationUser user, boolean issueCreation) {
        boolean permSchemeAllows = super.hasPermission(permissionsId, project, user, issueCreation);
        return this.workflowPermissionCheck(permSchemeAllows, permissionsId, project.getGenericValue(), ApplicationUsers.toDirectoryUser((ApplicationUser)user));
    }

    @Override
    public boolean hasPermission(int permissionId, GenericValue entity, User user, boolean issueCreation) {
        boolean permSchemeAllows = super.hasPermission(permissionId, entity, user, issueCreation);
        return this.workflowPermissionCheck(permSchemeAllows, permissionId, entity, user);
    }

    private boolean workflowPermissionCheck(boolean permissionSchemeAllows, int permissionId, GenericValue entity, User user) {
        String permName = Permissions.getShortName((int)permissionId);
        if (permissionSchemeAllows) {
            if (entity != null && "Issue".equals(entity.getEntityName())) {
                MutableIssue issue = ComponentAccessor.getIssueFactory().getIssue(entity);
                List<WorkflowPermission> workflowPerms = this.workflowPermissionFactory.getWorkflowPermissions(this.permissionContextFactory.getPermissionContext((Issue)issue), permissionId, false);
                this.addParentPermissionsIfSubTask(workflowPerms, (Issue)issue, permissionId);
                if (!workflowPerms.isEmpty()) {
                    for (WorkflowPermission permission : workflowPerms) {
                        if (permission.allows(permissionId, (Issue)issue, user)) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)(permName + " granted by permission scheme and " + permission));
                            }
                            return true;
                        }
                        if (!log.isInfoEnabled()) continue;
                        log.info((Object)("\t" + permName + " not granted by " + permission));
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)(permName + " granted by permission scheme but DENIED by workflow"));
                    }
                    return false;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(permName + " granted by permission scheme"));
                }
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(permName + " permission granted by permission scheme"));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(permName + " permission denied by permission scheme"));
        }
        return false;
    }

    private void addParentPermissionsIfSubTask(List<WorkflowPermission> workflowPerms, Issue issue, int permissionId) {
        SubTaskManager subTaskManager = ComponentManager.getInstance().getSubTaskManager();
        Issue parent = issue.getParentObject();
        if (subTaskManager.isSubTasksEnabled() && parent != null) {
            PermissionContext parentPermissionContext = this.permissionContextFactory.getPermissionContext(parent);
            workflowPerms.addAll(this.workflowPermissionFactory.getWorkflowPermissions(parentPermissionContext, permissionId, true));
        }
    }
}

