/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.GlobalPermissionEntry;
import com.atlassian.util.concurrent.ResettableLazyReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class GlobalPermissionsCache {
    private static final Logger log = Logger.getLogger(GlobalPermissionsCache.class);
    private final OfBizDelegator ofBizDelegator;
    private final ResettableLazyReference<GlobalPermissionCacheModel> cache = new ResettableLazyReference<GlobalPermissionCacheModel>(){

        protected GlobalPermissionCacheModel create() {
            return GlobalPermissionsCache.this.refresh();
        }
    };

    GlobalPermissionsCache(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
        if (log.isDebugEnabled()) {
            log.debug((Object)"GlobalPermissionsCache.GlobalPermissionsCache");
        }
    }

    public void clearCache() {
        this.cache.reset();
    }

    private GlobalPermissionCacheModel refresh() {
        HashSet<GlobalPermissionEntry> permissions = new HashSet<GlobalPermissionEntry>();
        HashMap<GlobalPermissionEntry, GenericValue> permGVs = new HashMap<GlobalPermissionEntry, GenericValue>();
        List allPermissions = this.ofBizDelegator.findAll("GlobalPermissionEntry");
        for (GenericValue permissionGV : allPermissions) {
            GlobalPermissionEntry permEntry = new GlobalPermissionEntry(permissionGV);
            boolean added = permissions.add(permEntry);
            added = permGVs.put(permEntry, permissionGV) == null && added;
            if (added) continue;
            log.warn((Object)("Could not add permission " + permEntry + " - it already existed?"));
        }
        return new GlobalPermissionCacheModel(permissions, permGVs);
    }

    public boolean hasPermission(GlobalPermissionEntry jiraPermission) {
        return ((GlobalPermissionCacheModel)this.cache.get()).globalPermissions.contains(jiraPermission);
    }

    public GenericValue getPermission(GlobalPermissionEntry jiraPermission) {
        return ((GlobalPermissionCacheModel)this.cache.get()).permissionGVMap.get(jiraPermission);
    }

    public Set<GlobalPermissionEntry> getPermissions() {
        return ((GlobalPermissionCacheModel)this.cache.get()).globalPermissions;
    }

    public Collection<GlobalPermissionEntry> getPermissions(String permissionType) {
        ArrayList<GlobalPermissionEntry> matchingPerms = new ArrayList<GlobalPermissionEntry>();
        for (GlobalPermissionEntry perm : ((GlobalPermissionCacheModel)this.cache.get()).globalPermissions) {
            if (!perm.getGlobalPermissionType().equals(permissionType)) continue;
            matchingPerms.add(perm);
        }
        return matchingPerms;
    }

    private static class GlobalPermissionCacheModel {
        Set<GlobalPermissionEntry> globalPermissions;
        Map<GlobalPermissionEntry, GenericValue> permissionGVMap;

        GlobalPermissionCacheModel(Set<GlobalPermissionEntry> globalPermissions, Map<GlobalPermissionEntry, GenericValue> permissionGVMap) {
            this.globalPermissions = globalPermissions;
            this.permissionGVMap = permissionGVMap;
        }
    }
}

