/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.fugue.Either;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueImpl;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectImpl;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.plugin.ProjectPermissionOverride;
import com.atlassian.jira.security.plugin.ProjectPermissionOverrideModuleDescriptor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultPermissionManager
implements PermissionManager {
    private static final Logger log = Logger.getLogger(DefaultPermissionManager.class);

    public void addPermission(int permissionsId, GenericValue scheme, String parameter, String securityType) throws CreateException {
        if (this.isGlobalPermission(permissionsId) && scheme != null) {
            throw new IllegalArgumentException("Can not create a global permissions in a scheme");
        }
        if (scheme == null) {
            ComponentAccessor.getGlobalPermissionManager().addPermission(permissionsId, parameter);
        } else {
            SchemeEntity schemeEntity = new SchemeEntity(securityType, parameter, (Object)permissionsId);
            try {
                ComponentAccessor.getPermissionSchemeManager().createSchemeEntity(scheme, schemeEntity);
            }
            catch (GenericEntityException e) {
                throw new CreateException((Exception)((Object)e));
            }
        }
    }

    public boolean hasPermission(int permissionsId, User user) {
        return this.doGlobalPermissionCheck(permissionsId, ApplicationUsers.from((User)user));
    }

    public boolean hasPermission(int permissionsId, ApplicationUser user) {
        return this.doGlobalPermissionCheck(permissionsId, user);
    }

    private boolean doGlobalPermissionCheck(int permissionsId, ApplicationUser user) {
        if (!this.isGlobalPermission(permissionsId)) {
            throw new IllegalArgumentException("Expected global permission, got " + permissionsId);
        }
        if (user == null) {
            return ComponentAccessor.getGlobalPermissionManager().hasPermission(permissionsId);
        }
        return user.isActive() && ComponentAccessor.getGlobalPermissionManager().hasPermission(permissionsId, user);
    }

    public boolean hasPermission(final int permissionId, GenericValue projectOrIssue, final User user) {
        return (Boolean)this.getProjectOrIssue(projectOrIssue).fold((Function)new Function<Project, Boolean>(){

            public Boolean apply(Project project) {
                boolean corePermissionCheckResult = DefaultPermissionManager.this.doProjectPermissionCheck(permissionId, project, user, false);
                return DefaultPermissionManager.this.withPermissionOverriding(corePermissionCheckResult, permissionId, project, ApplicationUsers.from((User)user));
            }
        }, (Function)new Function<Issue, Boolean>(){

            public Boolean apply(Issue issue) {
                boolean corePermissionCheckResult = DefaultPermissionManager.this.doIssuePermissionCheck(permissionId, issue, user, false);
                return DefaultPermissionManager.this.withPermissionOverriding(corePermissionCheckResult, permissionId, issue.getProjectObject(), ApplicationUsers.from((User)user));
            }
        });
    }

    public boolean hasPermission(int permissionsId, Issue issue, User user) {
        return this.withPermissionOverriding(this.doIssuePermissionCheck(permissionsId, issue, user), permissionsId, issue.getProjectObject(), ApplicationUsers.from((User)user));
    }

    public boolean hasPermission(int permissionsId, Issue issue, ApplicationUser user) {
        return this.withPermissionOverriding(this.doIssuePermissionCheck(permissionsId, issue, ApplicationUsers.toDirectoryUser((ApplicationUser)user)), permissionsId, issue.getProjectObject(), user);
    }

    public boolean hasPermission(int permissionsId, Project project, User user) {
        return this.withPermissionOverriding(this.doProjectPermissionCheck(permissionsId, project, user, false), permissionsId, project, ApplicationUsers.from((User)user));
    }

    public boolean hasPermission(int permissionsId, Project project, ApplicationUser user) {
        return this.withPermissionOverriding(this.doProjectPermissionCheck(permissionsId, project, ApplicationUsers.toDirectoryUser((ApplicationUser)user), false), permissionsId, project, user);
    }

    public boolean hasPermission(int permissionsId, Project project, User user, boolean issueCreation) {
        return this.withPermissionOverriding(this.doProjectPermissionCheck(permissionsId, project, user, issueCreation), permissionsId, project, ApplicationUsers.from((User)user));
    }

    public boolean hasPermission(int permissionsId, Project project, ApplicationUser user, boolean issueCreation) {
        return this.withPermissionOverriding(this.doProjectPermissionCheck(permissionsId, project, ApplicationUsers.toDirectoryUser((ApplicationUser)user), issueCreation), permissionsId, project, user);
    }

    public boolean hasPermission(final int permissionId, GenericValue entity, final User user, final boolean issueCreation) {
        return (Boolean)this.getProjectOrIssue(entity).fold((Function)new Function<Project, Boolean>(){

            public Boolean apply(Project project) {
                boolean corePermissionCheckResult = DefaultPermissionManager.this.doProjectPermissionCheck(permissionId, project, user, issueCreation);
                return DefaultPermissionManager.this.withPermissionOverriding(corePermissionCheckResult, permissionId, project, ApplicationUsers.from((User)user));
            }
        }, (Function)new Function<Issue, Boolean>(){

            public Boolean apply(Issue issue) {
                boolean corePermissionCheckResult = DefaultPermissionManager.this.doIssuePermissionCheck(permissionId, issue, user, issueCreation);
                return DefaultPermissionManager.this.withPermissionOverriding(corePermissionCheckResult, permissionId, issue.getProjectObject(), ApplicationUsers.from((User)user));
            }
        });
    }

    private boolean doIssuePermissionCheck(int permissionsId, Issue issue, User user) {
        if (issue.getId() != null) {
            return this.doIssuePermissionCheck(permissionsId, issue, user, false);
        }
        return this.doProjectPermissionCheck(permissionsId, issue.getProjectObject(), user, true);
    }

    private boolean doIssuePermissionCheck(int permissionId, Issue issue, User user, boolean issueCreation) {
        if (!this.doProjectPermissionCheck(permissionId, issue.getProjectObject(), user, false)) {
            return false;
        }
        if (!this.doEntityPermissionCheck(permissionId, issue.getGenericValue(), user, issueCreation)) {
            return false;
        }
        if (user == null) {
            return ((IssueSecuritySchemeManager)ComponentAccessor.getComponent(IssueSecuritySchemeManager.class)).hasSchemeAuthority(issue.getSecurityLevelId(), issue.getGenericValue());
        }
        return ((IssueSecuritySchemeManager)ComponentAccessor.getComponent(IssueSecuritySchemeManager.class)).hasSchemeAuthority(issue.getSecurityLevelId(), issue.getGenericValue(), user, issueCreation);
    }

    private boolean doProjectPermissionCheck(int permissionId, Project project, User user, boolean issueCreation) {
        if (this.isGlobalPermission(permissionId)) {
            throw new IllegalArgumentException("PermissionType passed to this function must NOT be a global permission, " + permissionId + " is global");
        }
        if (project == null || project.getId() == null) {
            throw new IllegalArgumentException("The Project argument and its backing generic value must not be null");
        }
        return this.doEntityPermissionCheck(permissionId, project.getGenericValue(), user, issueCreation);
    }

    protected boolean doEntityPermissionCheck(int permission, GenericValue entity, User user, boolean issueCreation) {
        if (user == null) {
            return ComponentAccessor.getPermissionSchemeManager().hasSchemeAuthority(Long.valueOf(permission), entity);
        }
        return user.isActive() && ComponentAccessor.getPermissionSchemeManager().hasSchemeAuthority(Long.valueOf(permission), entity, user, issueCreation);
    }

    public void removeGroupPermissions(String group) throws RemoveException {
        Assertions.notNull((String)"group", (Object)group);
        Assertions.notNull((Object)ComponentAccessor.getGroupManager().getGroup(group));
        ComponentAccessor.getGlobalPermissionManager().removePermissions(group);
        ComponentAccessor.getPermissionSchemeManager().removeEntities("group", group);
        ((IssueSecuritySchemeManager)ComponentAccessor.getComponent(IssueSecuritySchemeManager.class)).removeEntities("group", group);
    }

    public void removeUserPermissions(String username) throws RemoveException {
        Assertions.notNull((String)"username", (Object)username);
        ApplicationUser user = ComponentAccessor.getUserManager().getUserByName(username);
        Assertions.notNull((String)username, (Object)user);
        this.removeUserPermissions(user);
    }

    public void removeUserPermissions(ApplicationUser user) throws RemoveException {
        Assertions.notNull((String)"user", (Object)user);
        ComponentAccessor.getPermissionSchemeManager().removeEntities("user", user.getKey());
        ((IssueSecuritySchemeManager)ComponentAccessor.getComponent(IssueSecuritySchemeManager.class)).removeEntities("user", user.getKey());
    }

    public boolean hasProjects(int permissionId, User user) {
        return this.hasProjects(permissionId, ApplicationUsers.from((User)user));
    }

    public boolean hasProjects(final int permissionId, final ApplicationUser user) {
        if (this.isGlobalPermission(permissionId)) {
            throw new IllegalArgumentException("Permission type passed must NOT be a global permission " + permissionId + " is global");
        }
        return Iterables.any((Iterable)ComponentAccessor.getProjectManager().getProjectObjects(), (Predicate)new Predicate<Project>(){

            public boolean apply(Project project) {
                return DefaultPermissionManager.this.hasPermission(permissionId, project, user);
            }
        });
    }

    public Collection<Project> getProjectObjects(int permissionId, User user) {
        if (this.isGlobalPermission(permissionId)) {
            throw new IllegalArgumentException("Permission type passed must NOT be a global permission " + permissionId + " is global");
        }
        return this.getProjectObjectsWithPermission(ComponentAccessor.getProjectManager().getProjectObjects(), permissionId, user);
    }

    public Collection<Project> getProjects(int permissionId, ApplicationUser user) {
        return this.getProjectObjects(permissionId, ApplicationUsers.toDirectoryUser((ApplicationUser)user));
    }

    public Collection<GenericValue> getProjects(int permissionId, User user, GenericValue category) {
        if (this.isGlobalPermission(permissionId)) {
            throw new IllegalArgumentException("Permission type passed must NOT be a global permission, " + permissionId + " is global");
        }
        Collection projects = category == null ? ComponentAccessor.getProjectManager().getProjectsWithNoCategory() : ComponentAccessor.getProjectManager().getProjectsFromProjectCategory(category);
        return this.getProjectsWithPermission(projects, permissionId, user);
    }

    public Collection<Project> getProjects(int permissionId, User user, ProjectCategory projectCategory) {
        if (this.isGlobalPermission(permissionId)) {
            throw new IllegalArgumentException("Permission type passed must NOT be a global permission, " + permissionId + " is global");
        }
        Collection projects = projectCategory == null ? ComponentAccessor.getProjectManager().getProjectObjectsWithNoCategory() : ComponentAccessor.getProjectManager().getProjectsFromProjectCategory(projectCategory);
        return this.getProjectObjectsWithPermission(projects, permissionId, user);
    }

    public Collection<Project> getProjects(int permissionId, ApplicationUser user, ProjectCategory projectCategory) {
        return this.getProjects(permissionId, ApplicationUsers.toDirectoryUser((ApplicationUser)user), projectCategory);
    }

    private Collection<GenericValue> getProjectsWithPermission(Collection<GenericValue> projects, int permissionId, User user) {
        ArrayList<GenericValue> permissibleProjects = new ArrayList<GenericValue>();
        for (GenericValue project : projects) {
            if (!this.hasPermission(permissionId, project, user)) continue;
            permissibleProjects.add(project);
        }
        return permissibleProjects;
    }

    private Collection<Project> getProjectObjectsWithPermission(Collection<Project> projects, final int permissionId, final User user) {
        return Lists.newArrayList((Iterable)Iterables.filter(projects, (Predicate)new Predicate<Project>(){

            public boolean apply(Project project) {
                return DefaultPermissionManager.this.hasPermission(permissionId, project, user);
            }
        }));
    }

    protected boolean isGlobalPermission(int permissionId) {
        return Permissions.isGlobalPermission((int)permissionId);
    }

    public Collection<Group> getAllGroups(int permissionId, Project project) {
        HashSet<Group> groups = new HashSet<Group>();
        groups.addAll(ComponentAccessor.getPermissionSchemeManager().getGroups(Long.valueOf(permissionId), project));
        groups.addAll(ComponentAccessor.getGlobalPermissionManager().getGroupsWithPermission(permissionId));
        return groups;
    }

    public Collection<GenericValue> getProjects(int permissionId, User user) {
        if (this.isGlobalPermission(permissionId)) {
            throw new IllegalArgumentException("Permission type passed must NOT be a global permission " + permissionId + " is global");
        }
        Collection projects = ComponentAccessor.getProjectManager().getProjects();
        return this.getProjectsWithPermission(projects, permissionId, user);
    }

    private boolean withPermissionOverriding(boolean corePermissionCheckResult, int permissionId, final Project project, final ApplicationUser applicationUser) {
        if (!corePermissionCheckResult || 10 == permissionId) {
            return corePermissionCheckResult;
        }
        final ProjectPermissionKey permissionKey = new ProjectPermissionKey(permissionId);
        Boolean pluginPermissionCheckDeclined = (Boolean)Objects.firstNonNull((Object)Iterables.any((Iterable)ComponentAccessor.getPluginAccessor().getEnabledModuleDescriptorsByClass(ProjectPermissionOverrideModuleDescriptor.class), (Predicate)new Predicate<ProjectPermissionOverrideModuleDescriptor>(){

            public boolean apply(ProjectPermissionOverrideModuleDescriptor permissionOverrideModuleDescriptor) {
                return SafePluginPointAccess.safe((Predicate)new Predicate<ProjectPermissionOverrideModuleDescriptor>(){

                    public boolean apply(ProjectPermissionOverrideModuleDescriptor permissionOverrideModuleDescriptor) {
                        ProjectPermissionOverride.Decision decision = ((ProjectPermissionOverride)permissionOverrideModuleDescriptor.getModule()).hasPermission(permissionKey, project, applicationUser);
                        if (log.isDebugEnabled() && decision == ProjectPermissionOverride.Decision.DENY) {
                            log.debug((Object)("Permission check result to project " + project.getKey() + "was overriden by " + permissionOverrideModuleDescriptor.getCompleteKey()));
                        }
                        return decision == ProjectPermissionOverride.Decision.DENY;
                    }
                }).apply((Object)permissionOverrideModuleDescriptor);
            }
        }), (Object)false);
        return pluginPermissionCheckDeclined == false;
    }

    private Either<Project, Issue> getProjectOrIssue(GenericValue entity) {
        Assertions.notNull((String)"entity", (Object)entity);
        if ("Issue".equals(entity.getEntityName())) {
            return Either.right((Object)IssueImpl.getIssueObject(entity));
        }
        if ("Project".equals(entity.getEntityName())) {
            return Either.left((Object)new ProjectImpl(entity));
        }
        throw new IllegalArgumentException("The entity passed must be a Project or an Issue not a " + entity.getEntityName());
    }
}

