/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.permission.GlobalPermissionAddedEvent;
import com.atlassian.jira.event.permission.GlobalPermissionDeletedEvent;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.GlobalPermissionType;
import com.atlassian.jira.security.GlobalPermissionEntry;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.GlobalPermissionsCache;
import com.atlassian.jira.security.JiraPermission;
import com.atlassian.jira.security.JiraPermissionImpl;
import com.atlassian.jira.security.plugin.GlobalPermissionTypesManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class DefaultGlobalPermissionManager
implements GlobalPermissionManager {
    private final GlobalPermissionsCache globalPermissionsCache;
    private final CrowdService crowdService;
    private final OfBizDelegator ofBizDelegator;
    private final EventPublisher eventPublisher;
    private final GlobalPermissionTypesManager globalPermissionTypesManager;

    public DefaultGlobalPermissionManager(CrowdService crowdService, OfBizDelegator ofBizDelegator, EventPublisher eventPublisher, GlobalPermissionTypesManager globalPermissionTypesManager) {
        this.crowdService = crowdService;
        this.ofBizDelegator = ofBizDelegator;
        this.eventPublisher = eventPublisher;
        this.globalPermissionTypesManager = globalPermissionTypesManager;
        this.globalPermissionsCache = new GlobalPermissionsCache(ofBizDelegator);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.globalPermissionsCache.clearCache();
    }

    public Collection<GlobalPermissionType> getAllGlobalPermissions() {
        return this.globalPermissionTypesManager.getAll();
    }

    public Option<GlobalPermissionType> getGlobalPermission(int permissionId) {
        final String translatedPermissionKey = (String)GlobalPermissionType.GLOBAL_PERMISSION_ID_TRANSLATION.get((Object)permissionId);
        return Option.option((Object)Iterables.find(this.getAllGlobalPermissions(), (Predicate)new Predicate<GlobalPermissionType>(){

            public boolean apply(GlobalPermissionType globalPermissionType) {
                return globalPermissionType.getKey().equals(translatedPermissionKey);
            }
        }, null));
    }

    public Option<GlobalPermissionType> getGlobalPermission(@NotNull String permissionKey) {
        return this.globalPermissionTypesManager.getGlobalPermission(permissionKey);
    }

    public boolean addPermission(final int permissionId, final String group) {
        return (Boolean)this.getGlobalPermission(permissionId).fold((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                throw new IllegalArgumentException("Permission id passed must be a global permission, " + permissionId + " is not");
            }
        }, (Function)new Function<GlobalPermissionType, Boolean>(){

            public Boolean apply(GlobalPermissionType globalPermissionType) {
                return DefaultGlobalPermissionManager.this.addPermission(globalPermissionType, group);
            }
        });
    }

    public boolean addPermission(GlobalPermissionType globalPermissionType, String group) {
        if (!globalPermissionType.isAnonymousAllowed() && group == null) {
            throw new IllegalArgumentException("The group Anyone cannot be added to the global permission JIRA Users");
        }
        this.ofBizDelegator.createValue("GlobalPermissionEntry", (Map)FieldMap.build((String)"permission", (Object)globalPermissionType.getKey()).add("group_id", (Object)group));
        this.globalPermissionsCache.clearCache();
        this.clearActiveUserCountIfNecessary(globalPermissionType.getKey());
        this.eventPublisher.publish((Object)new GlobalPermissionAddedEvent(globalPermissionType, group));
        return true;
    }

    public Collection<JiraPermission> getPermissions(int permissionType) {
        Option<GlobalPermissionType> globalPermissionOpt = this.getGlobalPermission(permissionType);
        if (globalPermissionOpt.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Collection<GlobalPermissionEntry> permissionEntries = this.getPermissions((GlobalPermissionType)globalPermissionOpt.get());
        ArrayList translatedEntries = Lists.newArrayList();
        for (GlobalPermissionEntry permissionEntry : permissionEntries) {
            if (!GlobalPermissionType.GLOBAL_PERMISSION_ID_TRANSLATION.inverse().containsKey((Object)permissionEntry.getGlobalPermissionType())) continue;
            Integer translatedId = (Integer)GlobalPermissionType.GLOBAL_PERMISSION_ID_TRANSLATION.inverse().get((Object)permissionEntry.getGlobalPermissionType());
            translatedEntries.add(new JiraPermissionImpl(translatedId, permissionEntry.getGroup(), "group"));
        }
        return translatedEntries;
    }

    public Collection<GlobalPermissionEntry> getPermissions(GlobalPermissionType globalPermissionType) {
        return this.globalPermissionsCache.getPermissions(globalPermissionType.getKey());
    }

    public boolean removePermission(final int permissionId, final String group) {
        return (Boolean)this.getGlobalPermission(permissionId).fold((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                throw new IllegalArgumentException("Permission id passed must be a global permission, " + permissionId + " is not");
            }
        }, (Function)new Function<GlobalPermissionType, Boolean>(){

            public Boolean apply(GlobalPermissionType globalPermissionType) {
                return DefaultGlobalPermissionManager.this.removePermission(globalPermissionType, group);
            }
        });
    }

    public boolean removePermission(GlobalPermissionType globalPermissionType, String group) {
        GlobalPermissionEntry jiraPermission = new GlobalPermissionEntry(globalPermissionType.getKey(), group);
        if (this.hasPermission(jiraPermission)) {
            GenericValue permGV = this.globalPermissionsCache.getPermission(jiraPermission);
            this.ofBizDelegator.removeAll((List)Lists.newArrayList((Object[])new GenericValue[]{permGV}));
            this.globalPermissionsCache.clearCache();
            this.clearActiveUserCountIfNecessary(globalPermissionType.getKey());
            this.eventPublisher.publish((Object)new GlobalPermissionDeletedEvent(globalPermissionType, group));
            return true;
        }
        return false;
    }

    public boolean removePermissions(String group) {
        if (group == null) {
            throw new IllegalArgumentException("Group passed must NOT be null");
        }
        if (this.crowdService.getGroup(group) == null) {
            throw new IllegalArgumentException("Group passed must exist");
        }
        Set<GlobalPermissionEntry> permissions = this.globalPermissionsCache.getPermissions();
        for (GlobalPermissionEntry permission : permissions) {
            if (!group.equals(permission.getGroup())) continue;
            this.ofBizDelegator.removeValue(this.globalPermissionsCache.getPermission(permission));
            this.clearActiveUserCountIfNecessary(permission.getGlobalPermissionType());
        }
        this.globalPermissionsCache.clearCache();
        return true;
    }

    public boolean hasPermission(int permissionId) {
        Option<GlobalPermissionType> globalPermissionOpt = this.getGlobalPermission(permissionId);
        if (globalPermissionOpt.isEmpty()) {
            return false;
        }
        return this.hasPermission((GlobalPermissionType)globalPermissionOpt.get());
    }

    public boolean hasPermission(@NotNull GlobalPermissionType globalPermissionType) {
        return this.hasPermission(new GlobalPermissionEntry(globalPermissionType.getKey()));
    }

    public boolean hasPermission(int permissionId, User user) {
        return this.hasPermission(permissionId, ApplicationUsers.from((User)user));
    }

    public boolean hasPermission(int permissionId, ApplicationUser user) {
        Option<GlobalPermissionType> globalPermissionOpt = this.getGlobalPermission(permissionId);
        if (globalPermissionOpt.isEmpty()) {
            return false;
        }
        return this.hasPermission((GlobalPermissionType)globalPermissionOpt.get(), user);
    }

    public boolean hasPermission(final @NotNull GlobalPermissionType globalPermissionType, @NotNull ApplicationUser user) {
        if (user == null) {
            throw new IllegalArgumentException("User passed to this function cannot be null");
        }
        if (this.hasPermission(globalPermissionType)) {
            return true;
        }
        if (!user.isActive()) {
            return false;
        }
        Iterable userGroups = this.crowdService.search(this.getGroupMembershipQuery(user.getDirectoryUser()));
        return Iterables.any((Iterable)userGroups, (Predicate)new Predicate<String>(){

            public boolean apply(String groupName) {
                return DefaultGlobalPermissionManager.this.hasPermission(new GlobalPermissionEntry(globalPermissionType.getKey(), groupName));
            }
        });
    }

    private MembershipQuery<String> getGroupMembershipQuery(User user) {
        return QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(user.getName()).returningAtMost(-1);
    }

    public Collection<Group> getGroupsWithPermission(int permissionId) {
        Option<GlobalPermissionType> globalPermissionOpt = this.getGlobalPermission(permissionId);
        if (globalPermissionOpt.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.getGroupsWithPermission((GlobalPermissionType)globalPermissionOpt.get());
    }

    public Collection<Group> getGroupsWithPermission(@NotNull GlobalPermissionType globalPermissionType) {
        ArrayList<Group> groups = new ArrayList<Group>();
        Collection<String> groupNames = this.getGroupNames(globalPermissionType);
        for (String groupName : groupNames) {
            Group group = this.crowdService.getGroup(groupName);
            if (group == null) continue;
            groups.add(group);
        }
        return Collections.unmodifiableCollection(groups);
    }

    public Collection<String> getGroupNames(int permissionId) {
        Option<GlobalPermissionType> globalPermissionOpt = this.getGlobalPermission(permissionId);
        if (globalPermissionOpt.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.getGroupNames((GlobalPermissionType)globalPermissionOpt.get());
    }

    public Collection<String> getGroupNames(@NotNull GlobalPermissionType globalPermissionType) {
        HashSet<String> groupNames = new HashSet<String>();
        Collection<GlobalPermissionEntry> permissions = this.globalPermissionsCache.getPermissions(globalPermissionType.getKey());
        for (GlobalPermissionEntry permissionEntry : permissions) {
            String group = permissionEntry.getGroup();
            if (group == null) continue;
            groupNames.add(group);
        }
        return Collections.unmodifiableCollection(groupNames);
    }

    public boolean isGlobalPermission(int permissionId) {
        final String translatedPermissionKey = (String)GlobalPermissionType.GLOBAL_PERMISSION_ID_TRANSLATION.get((Object)permissionId);
        if (StringUtils.isBlank((String)translatedPermissionKey)) {
            return false;
        }
        return Iterables.any(this.getAllGlobalPermissions(), (Predicate)new Predicate<GlobalPermissionType>(){

            public boolean apply(GlobalPermissionType globalPermissionType) {
                return globalPermissionType.getKey().equals(translatedPermissionKey);
            }
        });
    }

    protected boolean hasPermission(GlobalPermissionEntry permissionEntry) {
        if ("ADMINISTER".equals(permissionEntry.getGlobalPermissionType())) {
            return this.globalPermissionsCache.hasPermission(permissionEntry) || this.globalPermissionsCache.hasPermission(new GlobalPermissionEntry("SYSTEM_ADMIN", permissionEntry.getGroup()));
        }
        return this.globalPermissionsCache.hasPermission(permissionEntry);
    }

    private void clearActiveUserCountIfNecessary(String permissionKey) {
        Set usePermissions = GlobalPermissionType.getUsePermissions();
        if (usePermissions.contains(permissionKey)) {
            ComponentAccessor.getUserUtil().clearActiveUserCount();
        }
    }
}

