/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.screenshot.applet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;

public class MultiPartForm {
    private ArrayList fields = new ArrayList();
    private String boundary;
    private final String encoding;

    public MultiPartForm(String encoding) {
        this.encoding = encoding;
    }

    public void addPart(String name, String fileName, String type, byte[] value) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        String t = "Content-Disposition: form-data; name=\"" + name + "\"";
        if (fileName != null) {
            t = t + "; filename=\"" + fileName + "\"";
        }
        t = t + "\r\n";
        byte[] line = this.encodeString(t);
        os.write(line);
        if (type != null) {
            line = this.encodeString("Content-Type: " + type + "\r\n");
            os.write(line);
        }
        line = this.encodeString("\r\n");
        os.write(line);
        os.write(value);
        line = this.encodeString("\r\n");
        os.write(line);
        this.fields.add(os.toByteArray());
    }

    public byte[] toByteArray() throws IOException {
        this.boundary = this.findBoundary();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (byte[] value : this.fields) {
            this.writeBoundary(os);
            os.write(value);
        }
        this.writeEndBoundary(os);
        return os.toByteArray();
    }

    private void writeBoundary(OutputStream os) throws IOException {
        byte[] line = this.encodeString("--" + this.boundary + "\r\n");
        os.write(line);
    }

    private void writeEndBoundary(OutputStream os) throws IOException {
        byte[] line = this.encodeString("--" + this.boundary + "--" + "\r\n");
        os.write(line);
    }

    private String findBoundary() {
        try {
            long test = System.currentTimeMillis();
            while (true) {
                String s = Long.toHexString(test);
                byte[] d = this.encodeString("--" + s);
                if (!this.find(d)) {
                    return s;
                }
                ++test;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private boolean find(byte[] needle) {
        byte[][] data = new byte[this.fields.size()][];
        Iterator iterator = this.fields.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            data[i] = (byte[])iterator.next();
            ++i;
        }
        for (byte[] aData : data) {
            for (int j = 0; j < aData.length - needle.length; ++j) {
                for (int k = 0; k < needle.length && aData[j + k] == needle[k]; ++k) {
                    if (k != needle.length - 1) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getBoundary() {
        return this.boundary;
    }

    private byte[] encodeString(String s) throws UnsupportedEncodingException {
        return s.getBytes(this.encoding);
    }
}

