/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme.distiller;

import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.permission.Permission;
import com.atlassian.jira.permission.SchemePermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.scheme.SchemeManagerFactory;
import com.atlassian.jira.scheme.distiller.DistilledSchemeResult;
import com.atlassian.jira.scheme.distiller.DistilledSchemeResults;
import com.atlassian.jira.scheme.distiller.SchemeDistiller;
import com.atlassian.jira.scheme.distiller.SchemeEntityType;
import com.atlassian.jira.scheme.distiller.SchemeRelationships;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MultiHashMap;

public class SchemeDistillerImpl
implements SchemeDistiller {
    private SchemeManagerFactory schemeManagerFactory;
    private SchemePermissions schemePermissions;
    private EventTypeManager eventTypeManager;

    public SchemeDistillerImpl(SchemeManagerFactory schemeManagerFactory, SchemePermissions schemePermissions, EventTypeManager eventTypeManager) {
        this.schemeManagerFactory = schemeManagerFactory;
        this.schemePermissions = schemePermissions;
        this.eventTypeManager = eventTypeManager;
    }

    @Override
    public Scheme persistNewSchemeMappings(DistilledSchemeResult distilledSchemeResult) throws DataAccessException {
        SchemeManager schemeManager = this.schemeManagerFactory.getSchemeManager(distilledSchemeResult.getType());
        distilledSchemeResult.getResultingScheme().setName(distilledSchemeResult.getResultingSchemeTempName());
        Scheme scheme = schemeManager.createSchemeAndEntities(distilledSchemeResult.getResultingScheme());
        distilledSchemeResult.setResultingScheme(scheme);
        this.modifyAllProjectAssociations(schemeManager, distilledSchemeResult);
        return scheme;
    }

    @Override
    public SchemeRelationships getSchemeRelationships(DistilledSchemeResults distilledSchemeResults) {
        SchemeRelationships schemeRelationships = null;
        String schemeType = distilledSchemeResults.getSchemeType();
        if ("NotificationScheme".equals(schemeType)) {
            Map schemeTypes = this.eventTypeManager.getEventTypesMap();
            schemeRelationships = new SchemeRelationships(distilledSchemeResults.getDistilledSchemeResults(), distilledSchemeResults.getUnDistilledSchemes(), this.getNotificationTypes(schemeTypes));
        } else if ("PermissionScheme".equals(schemeType)) {
            Map<Integer, Permission> schemeTypes = this.schemePermissions.getSchemePermissions();
            schemeRelationships = new SchemeRelationships(distilledSchemeResults.getDistilledSchemeResults(), distilledSchemeResults.getUnDistilledSchemes(), this.getPermissionTypes(schemeTypes));
        }
        return schemeRelationships;
    }

    private Collection getNotificationTypes(Map events) {
        ArrayList<SchemeEntityType> notificationTypes = new ArrayList<SchemeEntityType>();
        Iterator i$ = events.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            EventType eventType = (EventType)entry.getValue();
            notificationTypes.add(new SchemeEntityType(entry.getKey(), eventType.getNameKey()));
        }
        return notificationTypes;
    }

    private Collection<SchemeEntityType> getPermissionTypes(Map<Integer, Permission> permissions) {
        ArrayList permissionTypes = Lists.newArrayListWithCapacity((int)permissions.size());
        for (Map.Entry<Integer, Permission> permission : permissions.entrySet()) {
            permissionTypes.add(new SchemeEntityType(permission.getKey().longValue(), permission.getValue().getNameKey()));
        }
        return permissionTypes;
    }

    private void modifyAllProjectAssociations(SchemeManager schemeManager, DistilledSchemeResult distilledSchemeResult) {
        for (Object o : distilledSchemeResult.getAllAssociatedProjects()) {
            Project project = (Project)o;
            schemeManager.removeSchemesFromProject(project);
            schemeManager.addSchemeToProject(project, distilledSchemeResult.getResultingScheme());
        }
    }

    @Override
    public DistilledSchemeResults distillSchemes(Collection schemes) {
        if (schemes == null) {
            return new DistilledSchemeResults(null);
        }
        String type = null;
        if (!schemes.isEmpty()) {
            type = ((Scheme)schemes.iterator().next()).getType();
        }
        MultiHashMap commonSchemeBucket = new MultiHashMap();
        for (Object scheme1 : schemes) {
            Scheme scheme = (Scheme)scheme1;
            commonSchemeBucket.put(new HashSet(scheme.getEntities()), (Object)scheme);
        }
        DistilledSchemeResults distilledSchemeResults = new DistilledSchemeResults(type);
        for (Object o : commonSchemeBucket.keySet()) {
            ArrayList commonSchemes = new ArrayList((Collection)commonSchemeBucket.get(o));
            if (commonSchemes.size() > 1) {
                distilledSchemeResults.addDistilledSchemeResult(this.getDistilledSchemeResult(commonSchemes));
                continue;
            }
            distilledSchemeResults.addUndistilledScheme((Scheme)commonSchemes.get(0));
        }
        return distilledSchemeResults;
    }

    private DistilledSchemeResult getDistilledSchemeResult(List commonSchemes) {
        MultiHashMap projectsByScheme = new MultiHashMap();
        String type = null;
        for (Object commonScheme : commonSchemes) {
            Scheme scheme = (Scheme)commonScheme;
            if (type == null) {
                type = scheme.getType();
            }
            for (Object o : this.getProjectsForScheme(scheme, type)) {
                Project project = (Project)o;
                projectsByScheme.put((Object)scheme, (Object)project);
            }
        }
        return new DistilledSchemeResult(type, commonSchemes, (Map)projectsByScheme, ((Scheme)commonSchemes.get(0)).cloneScheme());
    }

    private Collection getProjectsForScheme(Scheme scheme, String type) {
        List projects = null;
        SchemeManager schemeManager = this.schemeManagerFactory.getSchemeManager(type);
        if (scheme.getId() != null) {
            projects = schemeManager.getProjects(scheme);
        }
        if (projects == null) {
            projects = Collections.EMPTY_LIST;
        }
        return projects;
    }
}

