/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultSchemeFactory
implements SchemeFactory {
    public static final String NOTIFICATION_SCHEME = "NotificationScheme";
    public static final String PERMISSION_SCHEME = "PermissionScheme";
    public static final String ISSUE_SECURITY_SCHEME = "IssueSecurityScheme";
    public static final String WORKFLOW_SCHEME = "WorkflowScheme";
    private static final String NOTIFICATION_ENTITY = "Notification";
    private static final String PERMISSION_ENTITY = "SchemePermissions";
    private static final String ISSUE_SECURITY_ENTITY = "SchemeIssueSecurities";
    private static final String WORKFLOW_SCHEME_ENTITY = "WorkflowSchemeEntity";

    @Override
    public Scheme getScheme(GenericValue schemeGV) throws DataAccessException {
        return this.getScheme(schemeGV, true);
    }

    @Override
    public List<Scheme> getSchemes(List<GenericValue> schemeGVs) throws DataAccessException {
        ArrayList<Scheme> schemes = new ArrayList<Scheme>();
        for (GenericValue schemeGV : schemeGVs) {
            schemes.add(this.getScheme(schemeGV, true));
        }
        return schemes;
    }

    @Override
    public Scheme getSchemeWithEntitiesComparable(GenericValue schemeGV) {
        return this.getScheme(schemeGV, false);
    }

    @Override
    public List<Scheme> getSchemesWithEntitiesComparable(List<GenericValue> schemeGVs) {
        ArrayList<Scheme> schemes = new ArrayList<Scheme>();
        for (GenericValue schemeGV : schemeGVs) {
            schemes.add(this.getScheme(schemeGV, false));
        }
        return schemes;
    }

    @Override
    public Scheme getScheme(GenericValue schemeGV, Collection<GenericValue> schemeEntityGVs) {
        Scheme scheme = this.getScheme(schemeGV);
        scheme.setEntities(this.convertToSchemeEntities(schemeEntityGVs, scheme.getId(), true));
        return scheme;
    }

    private Scheme getScheme(GenericValue schemeGV, boolean includeEntityIds) throws DataAccessException {
        try {
            Long id = schemeGV.getLong("id");
            String type = schemeGV.getEntityName();
            String name = schemeGV.getString("name");
            String description = schemeGV.getString("description");
            List schemeEntites = null;
            schemeEntites = NOTIFICATION_SCHEME.equals(type) ? ((NotificationSchemeManager)ComponentAccessor.getComponentOfType(NotificationSchemeManager.class)).getEntities(schemeGV) : (PERMISSION_SCHEME.equals(type) ? ((PermissionSchemeManager)ComponentAccessor.getComponentOfType(PermissionSchemeManager.class)).getEntities(schemeGV) : (ISSUE_SECURITY_SCHEME.equals(type) ? ((IssueSecuritySchemeManager)ComponentAccessor.getComponentOfType(IssueSecuritySchemeManager.class)).getEntities(schemeGV) : (WORKFLOW_SCHEME.equals(type) ? ((WorkflowSchemeManager)ComponentAccessor.getComponentOfType(WorkflowSchemeManager.class)).getEntities(schemeGV) : Collections.emptyList())));
            return new Scheme(id, type, name, description, this.convertToSchemeEntities(schemeEntites, id, includeEntityIds));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private Collection<SchemeEntity> convertToSchemeEntities(Collection<GenericValue> schemeEntityGVs, Long schemeId, boolean includeEntityIds) {
        ArrayList<SchemeEntity> entities = new ArrayList<SchemeEntity>();
        for (GenericValue schemeEntityGV : schemeEntityGVs) {
            String parameter;
            String type;
            Object entityTypeId;
            Long templateId;
            if (PERMISSION_ENTITY.equals(schemeEntityGV.getEntityName())) {
                templateId = null;
                entityTypeId = schemeEntityGV.getLong("permission");
                type = schemeEntityGV.getString("type");
                parameter = schemeEntityGV.getString("parameter");
            } else if (NOTIFICATION_ENTITY.equals(schemeEntityGV.getEntityName())) {
                templateId = schemeEntityGV.getLong("templateId");
                entityTypeId = schemeEntityGV.getLong("eventTypeId");
                type = schemeEntityGV.getString("type");
                parameter = schemeEntityGV.getString("parameter");
            } else if (ISSUE_SECURITY_ENTITY.equals(schemeEntityGV.getEntityName())) {
                templateId = null;
                entityTypeId = schemeEntityGV.getLong("security");
                type = schemeEntityGV.getString("type");
                parameter = schemeEntityGV.getString("parameter");
            } else if (WORKFLOW_SCHEME_ENTITY.equals(schemeEntityGV.getEntityName())) {
                templateId = null;
                entityTypeId = schemeEntityGV.getString("workflow");
                type = "issuetype";
                parameter = schemeEntityGV.getString("issuetype");
            } else {
                throw new IllegalArgumentException("Unrecognised Scheme entity '" + schemeEntityGV.getEntityName() + "'");
            }
            SchemeEntity schemeEntity = new SchemeEntity(includeEntityIds ? schemeEntityGV.getLong("id") : null, type, parameter, entityTypeId, (Object)templateId, includeEntityIds ? schemeId : null);
            entities.add(schemeEntity);
        }
        return entities;
    }
}

