/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeAddedToProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeCopiedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeComparator;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.SecurityTypeManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.util.concurrent.NotNull;
import com.atlassian.util.concurrent.Nullable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractSchemeManager
implements SchemeManager {
    private static final Logger log = Logger.getLogger(AbstractSchemeManager.class);
    static final String PROJECT_ENTITY_NAME = "Project";
    private final Cache<Long, List<GenericValue>> projectSchemeCache;
    protected final ProjectManager projectManager;
    protected final SecurityTypeManager securityTypeManager;
    private final PermissionContextFactory permissionContextFactory;
    protected final SchemeFactory schemeFactory;
    private final NodeAssociationStore nodeAssociationStore;
    private final OfBizDelegator ofBizDelegator;
    private final GroupManager groupManager;
    protected final EventPublisher eventPublisher;

    protected AbstractSchemeManager(ProjectManager projectManager, SecurityTypeManager securityTypeManager, PermissionContextFactory permissionContextFactory, SchemeFactory schemeFactory, NodeAssociationStore nodeAssociationStore, OfBizDelegator ofBizDelegator, GroupManager groupManager, EventPublisher eventPublisher, CacheManager cacheManager) {
        this.projectManager = projectManager;
        this.securityTypeManager = securityTypeManager;
        this.permissionContextFactory = permissionContextFactory;
        this.schemeFactory = schemeFactory;
        this.nodeAssociationStore = nodeAssociationStore;
        this.ofBizDelegator = ofBizDelegator;
        this.groupManager = groupManager;
        this.eventPublisher = eventPublisher;
        this.projectSchemeCache = cacheManager.getCache(this.getClass().getName() + ".projectSchemeCache", (CacheLoader)new ProjectSchemeCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    public void onClearCache(ClearCacheEvent event) {
        this.flushProjectSchemes();
    }

    public abstract String getSchemeEntityName();

    public abstract String getEntityName();

    public abstract String getSchemeDesc();

    public abstract String getDefaultNameKey();

    public abstract String getDefaultDescriptionKey();

    @Deprecated
    public String getAssociationType() {
        return "ProjectScheme";
    }

    protected abstract GenericValue createSchemeEntityNoEvent(GenericValue var1, SchemeEntity var2) throws GenericEntityException;

    public GenericValue getScheme(Long id) {
        return this.ofBizDelegator.findById(this.getSchemeEntityName(), id);
    }

    public Scheme getSchemeObject(Long id) throws DataAccessException {
        return this.getSchemeObject(EasyMap.build((Object)"id", (Object)id));
    }

    public Scheme getSchemeObject(String name) throws DataAccessException {
        return this.getSchemeObject(EasyMap.build((Object)"name", (Object)name));
    }

    private Scheme getSchemeObject(Map gvParams) {
        GenericValue schemeGv = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd(this.getSchemeEntityName(), gvParams));
        if (schemeGv != null) {
            return this.schemeFactory.getScheme(schemeGv);
        }
        return null;
    }

    public GenericValue getScheme(String name) throws DataAccessException {
        return EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd(this.getSchemeEntityName(), EasyMap.build((Object)"name", (Object)name)));
    }

    public List<GenericValue> getSchemes() throws DataAccessException {
        List schemes = this.ofBizDelegator.findAll(this.getSchemeEntityName());
        Collections.sort(schemes, OfBizComparators.NAME_COMPARATOR);
        return schemes;
    }

    public List<Scheme> getSchemeObjects() throws DataAccessException {
        List schemeGvs = this.ofBizDelegator.findAll(this.getSchemeEntityName());
        Collections.sort(schemeGvs, OfBizComparators.NAME_COMPARATOR);
        return this.schemeFactory.getSchemes(schemeGvs);
    }

    public List<Scheme> getAssociatedSchemes(boolean withEntitiesComparable) throws DataAccessException {
        ArrayList<Scheme> associatedSchemes = new ArrayList<Scheme>();
        try {
            List<GenericValue> schemes = this.getSchemes();
            for (GenericValue schemeGV : schemes) {
                if (this.getProjects(schemeGV).size() == 0) continue;
                if (withEntitiesComparable) {
                    associatedSchemes.add(this.schemeFactory.getSchemeWithEntitiesComparable(schemeGV));
                    continue;
                }
                associatedSchemes.add(this.schemeFactory.getScheme(schemeGV));
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        return associatedSchemes;
    }

    public List<Scheme> getUnassociatedSchemes() throws DataAccessException {
        ArrayList<Scheme> unassociatedSchemes = new ArrayList<Scheme>();
        try {
            List<GenericValue> schemes = this.getSchemes();
            for (GenericValue schemeGV : schemes) {
                if (!this.getProjects(schemeGV).isEmpty()) continue;
                unassociatedSchemes.add(this.schemeFactory.getScheme(schemeGV));
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        Collections.sort(unassociatedSchemes, new SchemeComparator());
        return unassociatedSchemes;
    }

    public List<GenericValue> getSchemes(GenericValue project) throws GenericEntityException {
        if (project == null) {
            throw new IllegalArgumentException("Cannot get schemes for null project");
        }
        return (List)this.projectSchemeCache.get((Object)project.getLong("id"));
    }

    public Scheme getSchemeFor(Project project) {
        try {
            List<GenericValue> schemes = this.getSchemes(project.getGenericValue());
            if (schemes.isEmpty()) {
                return null;
            }
            if (schemes.size() > 1) {
                throw new IllegalStateException("Too many " + this.getSchemeEntityName() + " schemes found for Project " + project.getKey());
            }
            return this.schemeFactory.getScheme(schemes.iterator().next());
        }
        catch (GenericEntityException ex) {
            throw new DataAccessException((Throwable)ex);
        }
    }

    public GenericValue getEntity(Long id) throws GenericEntityException {
        return this.ofBizDelegator.findById(this.getEntityName(), id);
    }

    public List<GenericValue> getEntities(String type, String parameter) throws GenericEntityException {
        List result = this.ofBizDelegator.findByAnd(this.getEntityName(), EasyMap.build((Object)"type", (Object)type, (Object)"parameter", (Object)parameter));
        return result;
    }

    public List<GenericValue> getEntities(GenericValue scheme) throws GenericEntityException {
        return scheme.getRelated("Child" + this.getEntityName());
    }

    public boolean schemeExists(String name) {
        return this.getScheme(name) != null;
    }

    public GenericValue createScheme(String name, String description) throws GenericEntityException {
        GenericValue newScheme = this.createSchemeNoEvent(name, description);
        this.eventPublisher.publish((Object)this.createSchemeCreatedEvent(this.schemeFactory.getScheme(newScheme)));
        return newScheme;
    }

    protected GenericValue createSchemeNoEvent(String name, String description) throws GenericEntityException {
        if (!this.schemeExists(name)) {
            this.flushProjectSchemes();
            GenericValue scheme = this.createSchemeGenericValue(MapBuilder.build((Object)"name", (Object)name, (Object)"description", (Object)description));
            return scheme;
        }
        throw new GenericEntityException("Could not create " + this.getSchemeDesc() + " Scheme with name:" + name + " as it already exists.");
    }

    protected abstract AbstractSchemeEvent createSchemeCreatedEvent(Scheme var1);

    public Scheme createSchemeObject(String name, String description) {
        try {
            return this.schemeFactory.getScheme(this.createScheme(name, description));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public Scheme createSchemeAndEntities(Scheme scheme) throws DataAccessException {
        GenericValue schemeGV;
        if (scheme == null) {
            throw new IllegalArgumentException();
        }
        try {
            schemeGV = this.createScheme(scheme.getName(), scheme.getDescription());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        ArrayList<GenericValue> entityGVs = new ArrayList<GenericValue>();
        Collection schemeEntities = scheme.getEntities();
        for (SchemeEntity schemeEntity : schemeEntities) {
            try {
                entityGVs.add(this.createSchemeEntity(schemeGV, schemeEntity));
            }
            catch (GenericEntityException e) {
                throw new DataAccessException((Throwable)e);
            }
        }
        return this.schemeFactory.getScheme(schemeGV, entityGVs);
    }

    protected abstract AbstractSchemeUpdatedEvent createSchemeUpdatedEvent(Scheme var1, Scheme var2);

    public void updateScheme(GenericValue entity) throws GenericEntityException {
        Long schemeId = entity.getLong("id");
        Scheme originalScheme = this.getSchemeObject(schemeId);
        entity.store();
        this.flushProjectSchemes();
        this.eventPublisher.publish((Object)this.createSchemeUpdatedEvent(this.getSchemeObject(schemeId), originalScheme));
    }

    public void updateScheme(Scheme scheme) throws DataAccessException {
        try {
            GenericValue schemeEntity = this.getScheme(scheme.getId());
            schemeEntity.setString("name", scheme.getName());
            schemeEntity.setString("description", scheme.getDescription());
            this.updateScheme(schemeEntity);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void deleteScheme(Long id) throws GenericEntityException {
        if (id != null && id != 0L) {
            GenericValue scheme = this.getScheme(id);
            this.nodeAssociationStore.removeAssociationsFromSink(scheme);
            this.ofBizDelegator.removeRelated("Child" + this.getEntityName(), scheme);
            this.ofBizDelegator.removeValue(scheme);
            this.flushProjectSchemes();
        }
    }

    @Deprecated
    public void addSchemeToProject(GenericValue project, GenericValue scheme) throws GenericEntityException {
        this.addSchemeToProject(this.projectManager.getProjectObj(project.getLong("id")), this.schemeFactory.getScheme(scheme));
    }

    public void addSchemeToProject(Project project, Scheme scheme) throws DataAccessException {
        if (project == null) {
            throw new IllegalArgumentException("The project passed can not be null.");
        }
        if (scheme == null) {
            throw new IllegalArgumentException("The scheme passed can not be null.");
        }
        try {
            List<GenericValue> schemes = this.getSchemes(project.getGenericValue());
            GenericValue schemeGV = this.getScheme(scheme.getId());
            if (!schemes.contains(schemeGV)) {
                this.nodeAssociationStore.createAssociation(project.getGenericValue(), schemeGV, this.getAssociationType());
            }
            this.flushProjectSchemes();
            this.eventPublisher.publish((Object)this.createSchemeAddedToProjectEvent(scheme, project));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @Nonnull
    protected abstract AbstractSchemeAddedToProjectEvent createSchemeAddedToProjectEvent(Scheme var1, Project var2);

    public void removeSchemesFromProject(Project project) throws DataAccessException {
        try {
            this.removeSchemesFromProject(project.getGenericValue());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @Deprecated
    public void removeSchemesFromProject(GenericValue project) throws GenericEntityException {
        List<GenericValue> schemes = this.getSchemes(project);
        for (GenericValue scheme : schemes) {
            this.nodeAssociationStore.removeAssociation(project, scheme, this.getAssociationType());
            this.eventPublisher.publish((Object)this.createSchemeRemovedFromProjectEvent(this.schemeFactory.getScheme(scheme), this.projectManager.getProjectObj(project.getLong("id"))));
        }
        this.flushProjectSchemes();
    }

    @Nonnull
    protected abstract AbstractSchemeRemovedFromProjectEvent createSchemeRemovedFromProjectEvent(Scheme var1, Project var2);

    public void deleteEntity(Long id) throws DataAccessException {
        try {
            GenericValue entity = this.getEntity(id);
            entity.remove();
            Object event = this.createSchemeEntityDeletedEvent(entity);
            if (event != null) {
                this.eventPublisher.publish(event);
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    protected abstract SchemeEntity makeSchemeEntity(GenericValue var1);

    @Nullable
    protected abstract Object createSchemeEntityDeletedEvent(GenericValue var1);

    @Deprecated
    public List<GenericValue> getProjects(GenericValue scheme) throws GenericEntityException {
        List<Long> projectIds = this.nodeAssociationStore.getSourceIdsFromSink(scheme, PROJECT_ENTITY_NAME, this.getAssociationType());
        ArrayList<GenericValue> projects = new ArrayList<GenericValue>();
        for (Long projectId : projectIds) {
            projects.add(this.projectManager.getProject(projectId));
        }
        Collections.sort(projects, OfBizComparators.NAME_COMPARATOR);
        return projects;
    }

    public List<Project> getProjects(Scheme scheme) throws DataAccessException {
        if (scheme == null || scheme.getId() == null) {
            throw new IllegalArgumentException("The scheme and the schemes id can not be null");
        }
        try {
            GenericValue schemeGV = this.getScheme(scheme.getId());
            return new ArrayList<Project>(ComponentAccessor.getProjectFactory().getProjects(this.getProjects(schemeGV)));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public GenericValue createDefaultScheme() throws GenericEntityException {
        if (this.getDefaultScheme() == null) {
            return this.createSchemeGenericValue(MapBuilder.build((Object)"id", (Object)0L, (Object)"name", (Object)this.getI18nTextWithDefaultNullCheck(this.getDefaultNameKey(), "Default " + this.getSchemeDesc() + " Scheme"), (Object)"description", (Object)this.getI18nTextWithDefaultNullCheck(this.getDefaultDescriptionKey(), "This is the default " + this.getSchemeDesc() + " Scheme. Any new projects that are created will be assigned this scheme")));
        }
        return this.getDefaultScheme();
    }

    public boolean removeEntities(String type, String parameter) throws RemoveException {
        if (type == null) {
            throw new IllegalArgumentException("Type passed must not be null");
        }
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter passed must not be null");
        }
        try {
            List<GenericValue> entities = this.getEntities(type, parameter);
            this.ofBizDelegator.removeAll(entities);
            return true;
        }
        catch (GenericEntityException e) {
            throw new RemoveException((Exception)((Object)e));
        }
    }

    public boolean removeEntities(GenericValue scheme, Long entityTypeId) throws RemoveException {
        if (scheme == null) {
            throw new IllegalArgumentException("Scheme passed to this function must not be NULL");
        }
        try {
            List entities = this.getEntities(scheme, entityTypeId);
            this.ofBizDelegator.removeAll(entities);
            return true;
        }
        catch (GenericEntityException e) {
            throw new RemoveException((Exception)((Object)e));
        }
    }

    public GenericValue getDefaultScheme() throws GenericEntityException {
        return this.ofBizDelegator.findById(this.getSchemeEntityName(), Long.valueOf(0L));
    }

    public Scheme getDefaultSchemeObject() {
        try {
            GenericValue defaultSchemeGV = this.getDefaultScheme();
            if (defaultSchemeGV == null) {
                return null;
            }
            return this.schemeFactory.getScheme(defaultSchemeGV);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void addDefaultSchemeToProject(GenericValue project) throws GenericEntityException {
        List<GenericValue> schemes;
        GenericValue scheme = this.getDefaultScheme();
        if (scheme != null && !(schemes = this.getSchemes(project)).contains(scheme)) {
            this.nodeAssociationStore.createAssociation(project, scheme, this.getAssociationType());
        }
        this.flushProjectSchemes();
    }

    public void addDefaultSchemeToProject(Project project) throws DataAccessException {
        try {
            this.addDefaultSchemeToProject(project.getGenericValue());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public GenericValue copyScheme(GenericValue oldScheme) throws GenericEntityException {
        if (oldScheme == null) {
            return null;
        }
        String name = this.getNameForCopy(oldScheme.getString("name"), null);
        GenericValue newScheme = this.createSchemeNoEvent(name, oldScheme.getString("description"));
        List<GenericValue> origEntities = this.getEntities(oldScheme);
        for (GenericValue entity : origEntities) {
            this.createSchemeEntityNoEvent(newScheme, this.makeSchemeEntity(entity));
        }
        this.eventPublisher.publish((Object)this.createSchemeCopiedEvent(this.schemeFactory.getScheme(oldScheme), this.schemeFactory.getScheme(newScheme)));
        return newScheme;
    }

    public String getNameForCopy(String originalName, Integer abbreviateTo) {
        String name = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper().getText("common.words.copyof", originalName);
        if (abbreviateTo != null) {
            name = StringUtils.abbreviate((String)name, (int)abbreviateTo);
        }
        int j = 2;
        while (this.schemeExists(name)) {
            name = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper().getText("common.words.copyxof", String.valueOf(j++), originalName);
            if (abbreviateTo == null) continue;
            name = StringUtils.abbreviate((String)name, (int)abbreviateTo);
        }
        return name;
    }

    @Nonnull
    protected abstract AbstractSchemeCopiedEvent createSchemeCopiedEvent(@Nonnull Scheme var1, @Nonnull Scheme var2);

    public Scheme copyScheme(Scheme oldScheme) {
        try {
            GenericValue newSchemeGv = this.copyScheme(this.getScheme(oldScheme.getId()));
            Scheme newScheme = this.schemeFactory.getScheme(newSchemeGv);
            return newScheme;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    protected void flushProjectSchemes() {
        this.projectSchemeCache.removeAll();
    }

    public Collection<Group> getGroups(Long entityTypeId, Project project) {
        return this.getGroups(entityTypeId, project.getGenericValue());
    }

    public Collection<Group> getGroups(Long entityTypeId, GenericValue project) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed can NOT be null");
        }
        if (!PROJECT_ENTITY_NAME.equals(project.getEntityName())) {
            throw new IllegalArgumentException("Project passed must be a project not a " + project.getEntityName());
        }
        HashSet<Group> groups = new HashSet<Group>();
        try {
            List<GenericValue> schemes = this.getSchemes(project);
            for (GenericValue scheme : schemes) {
                List entity = this.getEntities(scheme, "group", entityTypeId);
                for (GenericValue permission : entity) {
                    groups.add(this.groupManager.getGroup(permission.getString("parameter")));
                }
            }
        }
        catch (GenericEntityException e) {
            log.error((Object)e.getMessage());
            e.printStackTrace();
        }
        return groups;
    }

    public Collection<User> getUsers(Long permissionId, GenericValue projectOrIssue) {
        return this.getUsers(permissionId, this.permissionContextFactory.getPermissionContext(projectOrIssue));
    }

    public Collection<User> getUsers(Long permissionId, Project project) {
        return this.getUsers(permissionId, this.permissionContextFactory.getPermissionContext(project));
    }

    public Collection<User> getUsers(Long permissionId, Issue issue) {
        return this.getUsers(permissionId, this.permissionContextFactory.getPermissionContext(issue));
    }

    public Collection<User> getUsers(Long permissionId, PermissionContext ctx) {
        HashSet<User> users = new HashSet<User>();
        Map permTypes = this.securityTypeManager.getTypes();
        try {
            List<GenericValue> schemes = this.getSchemes(ctx.getProject());
            for (GenericValue scheme : schemes) {
                List entities = this.getEntities(scheme, permissionId);
                for (GenericValue entity : entities) {
                    SecurityType secType = (SecurityType)permTypes.get(entity.getString("type"));
                    if (secType == null) continue;
                    try {
                        Set<User> usersToAdd = secType.getUsers(ctx, entity.getString("parameter"));
                        for (User user : usersToAdd) {
                            if (!user.isActive()) continue;
                            users.add(user);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        log.warn((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (GenericEntityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return users;
    }

    protected GenericValue createSchemeGenericValue(Map<String, Object> values) throws GenericEntityException {
        return EntityUtils.createValue(this.getSchemeEntityName(), values);
    }

    private String getI18nTextWithDefaultNullCheck(String key, String defaultResult) {
        if (key == null) {
            return defaultResult;
        }
        String result = this.getApplicationI18n().getText(key);
        if (result.equals(key)) {
            return defaultResult;
        }
        return result;
    }

    I18nHelper getApplicationI18n() {
        return new I18nBean();
    }

    private class ProjectSchemeCacheLoader
    implements CacheLoader<Long, List<GenericValue>> {
        private ProjectSchemeCacheLoader() {
        }

        public List<GenericValue> load(@NotNull Long projectId) {
            List<GenericValue> sinkFromSource = AbstractSchemeManager.this.nodeAssociationStore.getSinksFromSource(AbstractSchemeManager.PROJECT_ENTITY_NAME, projectId, AbstractSchemeManager.this.getSchemeEntityName(), AbstractSchemeManager.this.getAssociationType());
            return ImmutableList.copyOf(sinkFromSource);
        }
    }
}

