/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sal;

import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.fugue.Option;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.base.Supplier;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;

public class JiraApplicationProperties
implements ApplicationProperties {
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final JiraHome jiraHome;
    private final com.atlassian.jira.config.properties.ApplicationProperties jiraApplicationProperties;
    private final BuildUtilsInfo buildUtilsInfo;
    private final Supplier<String> CANONICAL_BASE_URL_SUPPLIER = new Supplier<String>(){

        public String get() {
            return JiraApplicationProperties.this.getCanonicalBaseUrl();
        }
    };
    private final Supplier<String> CANONICAL_CONTEXT_PATH_SUPPLIER = new Supplier<String>(){

        public String get() {
            return JiraApplicationProperties.this.getCanonicalContextPath();
        }
    };

    public JiraApplicationProperties(VelocityRequestContextFactory velocityRequestContextFactory, JiraHome jiraHome, com.atlassian.jira.config.properties.ApplicationProperties jiraApplicationProperties, BuildUtilsInfo buildUtilsInfo) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.jiraHome = jiraHome;
        this.jiraApplicationProperties = jiraApplicationProperties;
        this.buildUtilsInfo = buildUtilsInfo;
    }

    public String getBaseUrl() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
    }

    public String getBaseUrl(UrlMode urlMode) {
        switch (urlMode) {
            case CANONICAL: {
                return this.getCanonicalBaseUrl();
            }
            case ABSOLUTE: {
                return (String)this.getBaseUrlFromRequest().getOrElse(this.CANONICAL_BASE_URL_SUPPLIER);
            }
            case RELATIVE: {
                return (String)this.getContextPathFromRequest().getOrElse(this.CANONICAL_CONTEXT_PATH_SUPPLIER);
            }
            case RELATIVE_CANONICAL: {
                return this.getCanonicalContextPath();
            }
            case AUTO: {
                return (String)this.getContextPathFromRequest().getOrElse(this.CANONICAL_BASE_URL_SUPPLIER);
            }
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private String getCanonicalBaseUrl() {
        return this.jiraApplicationProperties.getText("jira.baseurl");
    }

    private String getCanonicalContextPath() {
        String baseUrl = this.getCanonicalBaseUrl();
        try {
            return new URL(baseUrl).getPath();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Base URL misconfigured", e);
        }
    }

    private Option<String> getBaseUrlFromRequest() {
        HttpServletRequest request = ServletContextThreadLocal.getRequest();
        if (request != null) {
            return Option.some((Object)JiraUrl.constructBaseUrl((HttpServletRequest)request));
        }
        return Option.none();
    }

    private Option<String> getContextPathFromRequest() {
        HttpServletRequest request = ServletContextThreadLocal.getRequest();
        if (request != null) {
            return Option.some((Object)request.getContextPath());
        }
        return Option.none();
    }

    public String getApplicationName() {
        return this.jiraApplicationProperties.getText("jira.title");
    }

    public String getDisplayName() {
        return "JIRA";
    }

    public String getVersion() {
        return this.buildUtilsInfo.getVersion();
    }

    public Date getBuildDate() {
        return this.buildUtilsInfo.getCurrentBuildDate();
    }

    public String getBuildNumber() {
        return this.buildUtilsInfo.getCurrentBuildNumber();
    }

    public File getHomeDirectory() {
        return this.jiraHome.getHome();
    }

    public String getPropertyValue(String key) {
        return this.jiraApplicationProperties.getDefaultBackedString(key);
    }
}

