/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.jira.project.RemoteProject;
import com.atlassian.jira.project.RemoteProjectService;
import com.atlassian.jira.remote.UnauthorisedAppLink;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseStatusException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class RemoteProjectServiceImpl
implements RemoteProjectService {
    private static final Logger log = Logger.getLogger(RemoteProjectServiceImpl.class);
    private final ApplicationLinkService applicationLinkService;

    public RemoteProjectServiceImpl(ApplicationLinkService applicationLinkService) {
        this.applicationLinkService = applicationLinkService;
    }

    public RemoteProject getRemoteProject(ApplicationLink applicationLink, String key) throws CredentialsRequiredException, ResponseException {
        String response;
        ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
        ApplicationLinkRequest req = requestFactory.createRequest(Request.MethodType.GET, "/rest/api/2/project/" + key);
        try {
            response = req.execute();
        }
        catch (ResponseStatusException ex) {
            int statusCode = ex.getResponse().getStatusCode();
            if (statusCode == 401) {
                throw new CredentialsRequiredException((AuthorisationURIGenerator)applicationLink.createAuthenticatedRequestFactory(), ex.getMessage());
            }
            if (statusCode == 404) {
                return null;
            }
            throw ex;
        }
        try {
            return RemoteProject.from((ApplicationLink)applicationLink, (JSONObject)new JSONObject(response));
        }
        catch (JSONException ex) {
            throw new RuntimeException("Unable to parse project JSON response " + response, ex);
        }
    }

    public RemoteProjectService.RemoteProjectsResult findAllRemoteProjects() {
        LinkedList<RemoteProject> projects = new LinkedList<RemoteProject>();
        LinkedList<UnauthorisedAppLink> unauthorisedAppLinks = new LinkedList<UnauthorisedAppLink>();
        LinkedList<String> connectionErrors = new LinkedList<String>();
        for (ApplicationLink applicationLink : this.applicationLinkService.getApplicationLinks()) {
            log.debug((Object)("Gathering projects for " + applicationLink.getName() + "..."));
            try {
                projects.addAll(this.getRemoteProjects(applicationLink));
            }
            catch (CredentialsRequiredException ex) {
                unauthorisedAppLinks.add(new UnauthorisedAppLink(applicationLink, (AuthorisationURIGenerator)ex));
            }
            catch (ResponseStatusException ex) {
                int statusCode = ex.getResponse().getStatusCode();
                if (statusCode == 401) {
                    unauthorisedAppLinks.add(new UnauthorisedAppLink(applicationLink, (AuthorisationURIGenerator)applicationLink.createAuthenticatedRequestFactory()));
                    continue;
                }
                connectionErrors.add("Unexpected error when connecting to '" + applicationLink.getName() + "' (" + ex.getMessage() + ")");
            }
            catch (ResponseException ex) {
                connectionErrors.add("Unexpected error when connecting to '" + applicationLink.getName() + "' (" + ex.getMessage() + ")");
            }
        }
        return new RemoteProjectService.RemoteProjectsResult(projects, unauthorisedAppLinks, connectionErrors);
    }

    private Collection<RemoteProject> getRemoteProjects(ApplicationLink applicationLink) throws CredentialsRequiredException, ResponseException {
        ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
        ApplicationLinkRequest req = requestFactory.createRequest(Request.MethodType.GET, "/rest/api/2/project");
        return this.parseProjects(req.execute(), applicationLink);
    }

    private Collection<RemoteProject> parseProjects(String response, ApplicationLink applicationLink) throws ResponseException, CredentialsRequiredException {
        try {
            JSONArray json = new JSONArray(response);
            int length = json.length();
            ArrayList<RemoteProject> projects = new ArrayList<RemoteProject>(length);
            for (int i = 0; i < length; ++i) {
                projects.add(RemoteProject.from((ApplicationLink)applicationLink, (JSONObject)json.getJSONObject(i)));
            }
            return projects;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Unable to parse the JSON response for get projects : " + response, ex);
        }
    }
}

