/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.portal;

import com.atlassian.configurable.ValuesGenerator;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ListOrderedMap;

public class ColumnNamesValuesGenerator
implements ValuesGenerator {
    private final JiraAuthenticationContext authenticationContext = ComponentAccessor.getJiraAuthenticationContext();

    public Map getValues(Map params) {
        try {
            ListOrderedMap values = new ListOrderedMap();
            this.populateAllAvailableFields(values);
            this.putDefaultColumnsFirstInList(values);
            this.insertValueForSelectingDefaults(values);
            return values;
        }
        catch (FieldException e) {
            throw new RuntimeException(e);
        }
        catch (ColumnLayoutStorageException e) {
            throw new RuntimeException(e);
        }
    }

    private void insertValueForSelectingDefaults(ListOrderedMap values) {
        values.put(0, (Object)"--default--", (Object)this.authenticationContext.getI18nHelper().getText("portlet.abstractsearchresults.defaultcols"));
    }

    private void putDefaultColumnsFirstInList(ListOrderedMap values) throws ColumnLayoutStorageException {
        List columnLayoutItems = ComponentAccessor.getColumnLayoutManager().getDefaultColumnLayout(this.authenticationContext.getLoggedInUser()).getColumnLayoutItems();
        int i = 0;
        for (ColumnLayoutItem layoutItem : columnLayoutItems) {
            String fieldId = layoutItem.getId();
            if (!values.containsKey((Object)fieldId)) continue;
            String fieldName = (String)values.remove((Object)fieldId);
            values.put(i++, (Object)fieldId, (Object)fieldName);
        }
    }

    private void populateAllAvailableFields(ListOrderedMap values) throws FieldException {
        Set fields = ComponentAccessor.getFieldManager().getAvailableNavigableFields(this.authenticationContext.getLoggedInUser());
        for (Object field1 : fields) {
            Field field = (Field)field1;
            values.put((Object)field.getId(), (Object)field.getName());
        }
    }

    public static final class Property {
        public static final String DEFAULT_COLUMNS = "--default--";
    }
}

