/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.portal;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.gadgets.dashboard.Color;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.portal.FlushablePortletConfigurationStore;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.portal.PortletConfigurationImpl;
import com.atlassian.jira.portal.PortletConfigurationStore;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@EventComponent
public class CachingPortletConfigurationStore
implements FlushablePortletConfigurationStore {
    private final PortletConfigurationStore delegateStore;
    private final Cache<Long, List<Long>> cacheByPageId;
    private final Cache<Long, CacheObject<PortletConfiguration>> cacheById;

    public CachingPortletConfigurationStore(PortletConfigurationStore delegateStore, CacheManager cacheManager) {
        Assertions.notNull((String)"delegateStore", (Object)delegateStore);
        this.delegateStore = delegateStore;
        this.cacheByPageId = cacheManager.getCache(CachingPortletConfigurationStore.class.getName() + ".cacheByPageId", (CacheLoader)new ByPageIdCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.cacheById = cacheManager.getCache(CachingPortletConfigurationStore.class.getName() + ".cacheById", (CacheLoader)new ByIdCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cacheByPageId.removeAll();
        this.cacheById.removeAll();
    }

    @Override
    public List<PortletConfiguration> getByPortalPage(Long portalPageId) {
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        List configIds = (List)this.cacheByPageId.get((Object)portalPageId);
        ArrayList<PortletConfiguration> returnList = new ArrayList<PortletConfiguration>(configIds.size());
        for (Long element : configIds) {
            Long id = element;
            PortletConfiguration portletConfiguration = this.getByPortletId(id);
            if (portletConfiguration == null) continue;
            returnList.add(portletConfiguration);
        }
        return returnList;
    }

    @Override
    public PortletConfiguration getByPortletId(Long portletId) {
        Assertions.notNull((String)"portletId", (Object)portletId);
        return this.copyConfiguration((PortletConfiguration)((CacheObject)this.cacheById.get((Object)portletId)).getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(PortletConfiguration pc) {
        Assertions.notNull((String)"pc", (Object)pc);
        Assertions.notNull((String)"pc.id", (Object)pc.getId());
        try {
            this.delegateStore.delete(pc);
        }
        finally {
            this.cacheById.remove((Object)pc.getId());
            this.removePageFromCache(pc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateGadgetPosition(Long gadgetId, int row, int column, Long dashboardId) {
        Assertions.notNull((String)"gadgetId", (Object)gadgetId);
        Assertions.notNull((String)"dashboardId", (Object)dashboardId);
        Long existingDashboardId = null;
        try {
            PortletConfiguration portletConfiguration = (PortletConfiguration)((CacheObject)this.cacheById.get((Object)gadgetId)).getValue();
            Long l = existingDashboardId = portletConfiguration == null ? null : portletConfiguration.getDashboardPageId();
            if (existingDashboardId == null) {
                PortletConfiguration pc = this.delegateStore.getByPortletId(gadgetId);
                existingDashboardId = pc.getDashboardPageId();
            }
            this.delegateStore.updateGadgetPosition(gadgetId, row, column, dashboardId);
        }
        finally {
            this.cacheById.remove((Object)gadgetId);
            this.cacheByPageId.remove((Object)dashboardId);
            if (existingDashboardId != null) {
                this.cacheByPageId.remove((Object)existingDashboardId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateGadgetColor(Long gadgetId, Color color) {
        Assertions.notNull((String)"gadgetId", (Object)gadgetId);
        Assertions.notNull((String)"color", (Object)color);
        try {
            this.delegateStore.updateGadgetColor(gadgetId, color);
        }
        finally {
            this.cacheById.remove((Object)gadgetId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUserPrefs(Long gadgetId, Map<String, String> userPrefs) {
        Assertions.notNull((String)"gadgetId", (Object)gadgetId);
        Assertions.notNull((String)"userPrefs", userPrefs);
        try {
            this.delegateStore.updateUserPrefs(gadgetId, userPrefs);
        }
        finally {
            this.cacheById.remove((Object)gadgetId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(PortletConfiguration pc) {
        Assertions.notNull((String)"pc", (Object)pc);
        Assertions.notNull((String)"pc.id", (Object)pc.getId());
        try {
            this.delegateStore.store(pc);
        }
        finally {
            this.cacheById.remove((Object)pc.getId());
            this.removePageFromCache(pc);
            this.cacheByPageId.remove((Object)pc.getDashboardPageId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"UL_UNRELEASED_LOCK_EXCEPTION_PATH"}, justification="This appears to be doing exactly the right thing with the finally-clause to release the lock")
    public PortletConfiguration addGadget(Long pageId, Long portletConfigurationId, Integer column, Integer row, URI gadgetXml, Color color, Map<String, String> userPreferences) {
        Assertions.notNull((String)"pageId", (Object)pageId);
        Assertions.notNull((String)"column", (Object)column);
        Assertions.notNull((String)"row", (Object)row);
        Assertions.notNull((String)"gadgetXml", (Object)gadgetXml);
        Assertions.notNull((String)"userPreferences", userPreferences);
        Assertions.notNull((String)"color", (Object)color);
        PortletConfiguration returnConfig = null;
        try {
            returnConfig = this.delegateStore.addGadget(pageId, portletConfigurationId, column, row, gadgetXml, color, userPreferences);
        }
        finally {
            if (returnConfig != null) {
                this.cacheByPageId.remove((Object)returnConfig.getDashboardPageId());
            }
        }
        return this.copyConfiguration(returnConfig);
    }

    @Override
    public void flush() {
        this.cacheByPageId.removeAll();
        this.cacheById.removeAll();
    }

    @Override
    public EnclosedIterable<PortletConfiguration> getAllPortletConfigurations() {
        return this.delegateStore.getAllPortletConfigurations();
    }

    private void removePageFromCache(PortletConfiguration portletConfiguration) {
        Collection pageIds = this.cacheByPageId.getKeys();
        for (Long pageId : pageIds) {
            if (!((List)this.cacheByPageId.get((Object)pageId)).contains(portletConfiguration.getId())) continue;
            this.cacheByPageId.remove((Object)pageId);
        }
    }

    private PortletConfiguration copyConfiguration(PortletConfiguration portletConfiguration) {
        if (portletConfiguration != null) {
            return new PortletConfigurationImpl(portletConfiguration.getId(), portletConfiguration.getDashboardPageId(), portletConfiguration.getColumn(), portletConfiguration.getRow(), portletConfiguration.getGadgetURI(), portletConfiguration.getColor(), portletConfiguration.getUserPrefs());
        }
        return null;
    }

    private class ByIdCacheLoader
    implements CacheLoader<Long, CacheObject<PortletConfiguration>> {
        private ByIdCacheLoader() {
        }

        public CacheObject<PortletConfiguration> load(@NotNull Long portletId) {
            return CacheObject.wrap(CachingPortletConfigurationStore.this.delegateStore.getByPortletId(portletId));
        }
    }

    private class ByPageIdCacheLoader
    implements CacheLoader<Long, List<Long>> {
        private ByPageIdCacheLoader() {
        }

        public List<Long> load(@NotNull Long portletPageId) {
            List<PortletConfiguration> configs = CachingPortletConfigurationStore.this.delegateStore.getByPortalPage(portletPageId);
            if (configs != null) {
                ArrayList<Long> ownedSearchRequestIds = new ArrayList<Long>(configs.size());
                for (PortletConfiguration config : configs) {
                    ownedSearchRequestIds.add(config.getId());
                }
                return ImmutableList.copyOf(ownedSearchRequestIds);
            }
            return ImmutableList.of();
        }
    }
}

