/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webwork;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.plugin.webwork.AutowireCapableWebworkActionRegistry;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.AutowireCapablePlugin;
import com.atlassian.plugin.ModuleDescriptor;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DefaultAutowireCapableWebworkActionRegistry
implements AutowireCapableWebworkActionRegistry {
    @ClusterSafe
    final ConcurrentMap<String, ModuleDescriptor> registry = new ConcurrentHashMap<String, ModuleDescriptor>();

    public void registerAction(String action, ModuleDescriptor moduleDescriptor) {
        Assertions.notNull((String)"action", (Object)action);
        Assertions.notNull((String)"moduleDescriptor", (Object)moduleDescriptor);
        if (!(moduleDescriptor.getPlugin() instanceof AutowireCapablePlugin)) {
            throw new IllegalArgumentException("Plugin must be autowire capable in order to be registered: " + moduleDescriptor.getPluginKey());
        }
        this.registry.putIfAbsent(action, moduleDescriptor);
    }

    public void unregisterPluginModule(ModuleDescriptor moduleDescriptor) {
        Assertions.notNull((String)"moduleDescriptor", (Object)moduleDescriptor);
        Iterator iterator = this.registry.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!moduleDescriptor.getCompleteKey().equals(((ModuleDescriptor)entry.getValue()).getCompleteKey())) continue;
            iterator.remove();
        }
    }

    @Override
    public AutowireCapablePlugin getPlugin(String action) {
        ModuleDescriptor moduleDescriptor = (ModuleDescriptor)this.registry.get(action);
        if (moduleDescriptor != null) {
            return (AutowireCapablePlugin)moduleDescriptor.getPlugin();
        }
        return null;
    }

    @Override
    public boolean containsAction(String action) {
        return this.registry.containsKey(action);
    }
}

