/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractPermissionCondition;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Map;
import org.apache.log4j.Logger;

public class HasIssuePermissionCondition
extends AbstractPermissionCondition {
    private static final Logger log = Logger.getLogger(HasIssuePermissionCondition.class);

    public HasIssuePermissionCondition(PermissionManager permissionManager) {
        super(permissionManager);
    }

    public boolean shouldDisplay(ApplicationUser user, JiraHelper jiraHelper) {
        Map params = jiraHelper.getContextParams();
        Issue issue = (Issue)params.get("issue");
        if (issue == null) {
            log.warn((Object)"Trying to run permission condition on an issue, but no issue exists");
            return false;
        }
        return this.permissionManager.hasPermission(this.permission, issue, user);
    }
}

