/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugin.webfragment.JiraWebInterfaceManager;
import com.atlassian.jira.plugin.webfragment.SimpleLinkFactory;
import com.atlassian.jira.plugin.webfragment.SimpleLinkFactoryModuleDescriptors;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.descriptors.JiraWebItemModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.descriptors.JiraWebSectionModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.descriptors.SimpleLinkFactoryModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.JiraWebLabel;
import com.atlassian.jira.plugin.webfragment.model.JiraWebLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkImpl;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSectionImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.web.model.WebLabel;
import com.atlassian.plugin.web.model.WebLink;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class DefaultSimpleLinkManager
implements SimpleLinkManager {
    private static final Logger log = Logger.getLogger(DefaultSimpleLinkManager.class);
    private final JiraWebInterfaceManager webInterfaceManager;
    private final SimpleLinkFactoryModuleDescriptors simpleLinkFactoryModuleDescriptors;
    private final JiraAuthenticationContext authenticationContext;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final WebResourceUrlProvider webResourceUrlProvider;

    public DefaultSimpleLinkManager(JiraWebInterfaceManager webInterfaceManager, SimpleLinkFactoryModuleDescriptors simpleLinkFactoryModuleDescriptors, JiraAuthenticationContext authenticationContext, VelocityRequestContextFactory velocityRequestContextFactory, WebResourceUrlProvider webResourceUrlProvider) {
        this.webInterfaceManager = webInterfaceManager;
        this.simpleLinkFactoryModuleDescriptors = simpleLinkFactoryModuleDescriptors;
        this.authenticationContext = authenticationContext;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.webResourceUrlProvider = webResourceUrlProvider;
    }

    public boolean shouldLocationBeLazy(final @Nonnull String location, User remoteUser, @Nonnull JiraHelper jiraHelper) {
        List sections = this.webInterfaceManager.getDisplayableSections(location, remoteUser, jiraHelper);
        Iterable<SimpleLinkFactoryModuleDescriptor> linkFactories = this.simpleLinkFactoryModuleDescriptors.get();
        for (final JiraWebSectionModuleDescriptor section : sections) {
            class SectionPredicate
            implements Predicate<SimpleLinkFactoryModuleDescriptor> {
                final int locLength;
                final String key;
                final int length;

                SectionPredicate() {
                    this.locLength = location.length();
                    this.key = section.getKey();
                    this.length = this.locLength + 1 + this.key.length();
                }

                public boolean apply(SimpleLinkFactoryModuleDescriptor linkFactory) {
                    return this.nameMatches(linkFactory.getSection()) && linkFactory.shouldBeLazy();
                }

                boolean nameMatches(String name) {
                    return name.length() == this.length && name.startsWith(location) && name.charAt(this.locLength) == '/' && name.endsWith(this.key);
                }
            }
            if (!Iterables.any(linkFactories, (Predicate)new SectionPredicate())) continue;
            return true;
        }
        return false;
    }

    public boolean shouldSectionBeLazy(String section) {
        for (SimpleLinkFactoryModuleDescriptor linkFactory : this.simpleLinkFactoryModuleDescriptors.get()) {
            if (!section.equals(linkFactory.getSection()) || !linkFactory.shouldBeLazy()) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public List<SimpleLink> getLinksForSection(@Nonnull String section, User remoteUser, @Nonnull JiraHelper jiraHelper) {
        return this.getLinks(section, this.webInterfaceManager.getDisplayableItems(section, remoteUser, jiraHelper), remoteUser, jiraHelper, false);
    }

    @Nonnull
    public List<SimpleLink> getLinksForSection(@Nonnull String section, User remoteUser, @Nonnull JiraHelper jiraHelper, boolean addIconCachingPrefix) {
        return this.getLinks(section, this.webInterfaceManager.getDisplayableItems(section, remoteUser, jiraHelper), remoteUser, jiraHelper, addIconCachingPrefix);
    }

    @Nonnull
    public List<SimpleLink> getLinksForSectionIgnoreConditions(@Nonnull String section, User remoteUser, @Nonnull JiraHelper jiraHelper) {
        return this.getLinks(section, this.webInterfaceManager.getItems(section), remoteUser, jiraHelper, false);
    }

    private List<SimpleLink> getLinks(String section, List<JiraWebItemModuleDescriptor> items, User user, JiraHelper jiraHelper, boolean addIconCachingPrefix) {
        JiraWebItemModuleDescriptor item;
        ArrayList<SimpleLink> returnLinks = new ArrayList<SimpleLink>();
        ArrayList<SimpleLinkFactoryModuleDescriptor> matchingFactories = new ArrayList<SimpleLinkFactoryModuleDescriptor>();
        for (SimpleLinkFactoryModuleDescriptor linkFactory : this.simpleLinkFactoryModuleDescriptors.get()) {
            if (!section.equals(linkFactory.getSection())) continue;
            matchingFactories.add(linkFactory);
        }
        Iterator factoryIterator = matchingFactories.iterator();
        Iterator<JiraWebItemModuleDescriptor> itemIterator = items.iterator();
        SimpleLinkFactoryModuleDescriptor factory = factoryIterator.hasNext() ? (SimpleLinkFactoryModuleDescriptor)factoryIterator.next() : null;
        JiraWebItemModuleDescriptor jiraWebItemModuleDescriptor = item = itemIterator.hasNext() ? itemIterator.next() : null;
        while (factory != null || item != null) {
            SimpleLink link;
            SimpleLinkFactory factoryModule;
            if (factory != null && item != null) {
                if (factory.getWeight() < item.getWeight()) {
                    factoryModule = (SimpleLinkFactory)factory.getModule();
                    if (factoryModule != null) {
                        returnLinks.addAll(factoryModule.getLinks(user, jiraHelper.getContextParams()));
                    }
                    factory = factoryIterator.hasNext() ? (SimpleLinkFactoryModuleDescriptor)factoryIterator.next() : null;
                    continue;
                }
                link = this.convertWebItemToSimpleLink(item, user, jiraHelper, addIconCachingPrefix);
                if (link != null) {
                    returnLinks.add(link);
                }
                item = itemIterator.hasNext() ? itemIterator.next() : null;
                continue;
            }
            if (factory == null) {
                link = this.convertWebItemToSimpleLink(item, user, jiraHelper, addIconCachingPrefix);
                if (link != null) {
                    returnLinks.add(link);
                }
                item = itemIterator.hasNext() ? itemIterator.next() : null;
                continue;
            }
            factoryModule = (SimpleLinkFactory)factory.getModule();
            if (factoryModule != null) {
                returnLinks.addAll(factoryModule.getLinks(user, jiraHelper.getContextParams()));
            }
            factory = factoryIterator.hasNext() ? (SimpleLinkFactoryModuleDescriptor)factoryIterator.next() : null;
        }
        return returnLinks;
    }

    private SimpleLink convertWebItemToSimpleLink(JiraWebItemModuleDescriptor item, User user, JiraHelper helper, boolean addIconCachingPrefix) {
        try {
            WebLabel label = item.getLabel();
            String labelStr = null;
            Map ctx = MapBuilder.newBuilder().add((Object)"user", (Object)user).add((Object)"helper", (Object)helper).add((Object)"i18n", (Object)this.authenticationContext.getI18nHelper()).toMutableMap();
            ctx.putAll(helper.getContextParams());
            String pluginVersion = this.getPluginVersionFromItem(item);
            String staticResourcePrefix = this.webResourceUrlProvider.getStaticResourcePrefix(pluginVersion, UrlMode.RELATIVE);
            if (label != null) {
                labelStr = label instanceof JiraWebLabel ? ((JiraWebLabel)label).getDisplayableLabel(user, helper) : label.getDisplayableLabel(helper.getRequest(), ctx);
            }
            WebLabel tooltip = item.getTooltip();
            String tooltipStr = null;
            if (tooltip != null) {
                tooltipStr = tooltip instanceof JiraWebLabel ? ((JiraWebLabel)tooltip).getDisplayableLabel(user, helper) : tooltip.getDisplayableLabel(helper.getRequest(), ctx);
            }
            WebLink iconUrl = item.getIcon() == null ? null : item.getIcon().getUrl();
            String iconUrlStr = null;
            if (iconUrl != null && this.isRelativeUrl(iconUrlStr = iconUrl instanceof JiraWebLink ? ((JiraWebLink)iconUrl).getRenderedUrl(user, helper) : iconUrl.getRenderedUrl(ctx))) {
                if (addIconCachingPrefix) {
                    iconUrlStr = staticResourcePrefix + iconUrlStr;
                } else {
                    String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
                    iconUrlStr = baseUrl + iconUrlStr;
                }
            }
            WebLink url = item.getLink();
            String urlStr = null;
            String accessKey = null;
            String id = null;
            if (url != null) {
                id = url.getId();
                if (url instanceof JiraWebLink) {
                    urlStr = ((JiraWebLink)url).getDisplayableUrl(user, helper);
                    accessKey = ((JiraWebLink)url).getAccessKey(user, helper);
                } else {
                    urlStr = url.getDisplayableUrl(helper.getRequest(), ctx);
                    accessKey = url.getAccessKey(ctx);
                }
            }
            if (id == null) {
                id = item.getKey();
            }
            if (urlStr != null) {
                return new SimpleLinkImpl(id, labelStr, tooltipStr, iconUrlStr, item.getStyleClass(), item.getParams(), urlStr, accessKey, Integer.valueOf(item.getWeight()));
            }
            return null;
        }
        catch (RuntimeException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("RuntimeException converting item '" + item.getCompleteKey() + "' to Simple link. This link will be skipped."), (Throwable)e);
            } else {
                log.error((Object)("RuntimeException converting item '" + item.getCompleteKey() + "' to Simple link. This link will be skipped. " + e.getMessage()));
            }
            return null;
        }
    }

    private String getPluginVersionFromItem(JiraWebItemModuleDescriptor item) {
        if (item == null) {
            return "none";
        }
        Plugin plugin = item.getPlugin();
        if (plugin == null) {
            return "none";
        }
        PluginInformation pluginInformation = plugin.getPluginInformation();
        if (pluginInformation == null) {
            return "none";
        }
        String version = pluginInformation.getVersion();
        return version == null ? "none" : version;
    }

    private boolean isRelativeUrl(String url) {
        try {
            return !new URI(url).isAbsolute();
        }
        catch (URISyntaxException e) {
            return true;
        }
    }

    @Nonnull
    public List<SimpleLinkSection> getSectionsForLocation(@Nonnull String location, User remoteUser, @Nonnull JiraHelper jiraHelper) {
        List sections = this.webInterfaceManager.getDisplayableSections(location, remoteUser, jiraHelper);
        ArrayList<SimpleLinkSection> returnSections = new ArrayList<SimpleLinkSection>(sections.size());
        for (JiraWebSectionModuleDescriptor section : sections) {
            returnSections.add(this.convertWebSectionToSimpleLinkSection(section, remoteUser, jiraHelper));
        }
        return returnSections;
    }

    @Nonnull
    public List<SimpleLinkSection> getNotEmptySectionsForLocation(@Nonnull String location, User remoteUser, @Nonnull JiraHelper jiraHelper) {
        List<SimpleLinkSection> allSections = this.getSectionsForLocation(location, remoteUser, jiraHelper);
        ArrayList<SimpleLinkSection> notEmptySections = new ArrayList<SimpleLinkSection>(allSections.size());
        for (SimpleLinkSection section : allSections) {
            List<SimpleLink> directLinks = this.getLinksForSection(section.getId(), remoteUser, jiraHelper);
            if (directLinks.size() > 0) {
                notEmptySections.add(section);
                continue;
            }
            List<SimpleLink> links = this.getLinksForSection(location + "/" + section.getId(), remoteUser, jiraHelper);
            if (links.size() > 0) {
                notEmptySections.add(section);
                continue;
            }
            List<SimpleLinkSection> subSections = this.getNotEmptySectionsForLocation(section.getId(), remoteUser, jiraHelper);
            if (subSections.size() <= 0) continue;
            notEmptySections.add(section);
        }
        return notEmptySections;
    }

    private SimpleLinkSection convertWebSectionToSimpleLinkSection(JiraWebSectionModuleDescriptor descriptor, User user, JiraHelper helper) {
        WebLabel label = descriptor.getLabel();
        String labelStr = null;
        Map ctx = MapBuilder.newBuilder().add((Object)"user", (Object)user).add((Object)"helper", (Object)helper).add((Object)"i18n", (Object)this.authenticationContext.getI18nHelper()).toMutableMap();
        ctx.putAll(helper.getContextParams());
        if (label != null) {
            labelStr = label instanceof JiraWebLabel ? ((JiraWebLabel)label).getDisplayableLabel(user, helper) : label.getDisplayableLabel(helper.getRequest(), ctx);
        }
        WebLabel tooltip = descriptor.getTooltip();
        String tooltipStr = null;
        if (tooltip != null) {
            tooltipStr = tooltip instanceof JiraWebLabel ? ((JiraWebLabel)tooltip).getDisplayableLabel(user, helper) : tooltip.getDisplayableLabel(helper.getRequest(), ctx);
        }
        return new SimpleLinkSectionImpl(descriptor.getKey(), labelStr, tooltipStr, null, null, descriptor.getParams(), Integer.valueOf(descriptor.getWeight()));
    }

    public SimpleLinkSection getSectionForURL(@Nonnull String topLevelSection, @Nonnull String URL2, User remoteUser, JiraHelper jiraHelper) {
        return this.findWebSectionForURL(topLevelSection, URL2, remoteUser, jiraHelper);
    }

    private SimpleLinkSection findWebSectionForURL(String currentLocation, String targetURL, User remoteUser, JiraHelper jiraHelper) {
        List<SimpleLinkSection> sections = this.getSectionsForLocation(currentLocation, remoteUser, jiraHelper);
        SimpleLinkSection sectionForURL = null;
        block0: for (SimpleLinkSection section : sections) {
            String subSection = currentLocation + "/" + section.getId();
            List<SimpleLink> links = this.getLinksForSection(subSection, remoteUser, jiraHelper);
            for (SimpleLink link : links) {
                if (!targetURL.endsWith(JiraUrl.extractActionFromURL((String)link.getUrl()))) continue;
                sectionForURL = new SimpleLinkSectionImpl(subSection, (SimpleLinkSectionImpl)section);
                break block0;
            }
            sectionForURL = this.findWebSectionForURL(section.getId(), targetURL, remoteUser, jiraHelper);
            if (sectionForURL == null) continue;
            break;
        }
        return sectionForURL;
    }
}

