/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.userformat.descriptors;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.profile.UserFormat;
import com.atlassian.jira.plugin.userformat.UserFormatModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptors;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.plugin.AutowireCapablePlugin;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.util.concurrent.ResettableLazyReference;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class UserFormatModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<UserFormat>
implements UserFormatModuleDescriptor {
    private String type;
    private String typeI18nKey;
    @ClusterSafe(value="Plugins are kept in synch across the cluster")
    private final ResettableLazyReference<UserFormat> format = new ResettableLazyReference<UserFormat>(){

        protected UserFormat create() {
            Plugin plugin = UserFormatModuleDescriptorImpl.this.getPlugin();
            if (plugin instanceof AutowireCapablePlugin) {
                return (UserFormat)((AutowireCapablePlugin)plugin).autowire(UserFormatModuleDescriptorImpl.this.getModuleClass());
            }
            return (UserFormat)JiraUtils.loadComponent(UserFormatModuleDescriptorImpl.this.getModuleClass(), CollectionBuilder.list((Object[])new Object[]{UserFormatModuleDescriptorImpl.this}));
        }
    };

    public UserFormatModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        Element typeElement = element.element("type");
        this.type = typeElement.getTextTrim();
        Attribute typeI18nAttribute = typeElement.attribute("i18n-name-key");
        if (typeI18nAttribute != null) {
            this.typeI18nKey = typeI18nAttribute.getText();
        }
    }

    @Override
    public void enabled() {
        super.enabled();
        this.assertModuleClassImplements(UserFormat.class);
        this.format.reset();
    }

    @Override
    public void disabled() {
        super.disabled();
        this.format.reset();
    }

    public String getType() {
        return this.type;
    }

    public String getTypeI18nKey() {
        return this.typeI18nKey;
    }

    @Override
    public UserFormat getModule() {
        try {
            return (UserFormat)this.format.get();
        }
        catch (LazyReference.InitializationException e) {
            this.format.reset();
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw e;
        }
    }

    public boolean equals(Object obj) {
        return new ModuleDescriptors.EqualsBuilder((ModuleDescriptor)this).isEqualsTo(obj);
    }

    public int hashCode() {
        return new ModuleDescriptors.HashCodeBuilder((ModuleDescriptor)this).toHashCode();
    }
}

