/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.navigation;

import com.atlassian.jira.ajsmeta.HtmlMetadataManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutManager;
import com.atlassian.jira.plugin.navigation.FooterModuleDescriptor;
import com.atlassian.jira.plugin.navigation.PluggableFooter;
import com.atlassian.jira.plugin.navigation.PluggableTopNavigation;
import com.atlassian.jira.plugin.navigation.TopNavigationModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorComparator;
import com.atlassian.jira.plugin.webfragment.DefaultWebFragmentContext;
import com.atlassian.jira.web.filters.accesslog.AccessLogImprinter;
import com.atlassian.jira.web.pagebuilder.DecoratablePage;
import com.atlassian.jira.web.util.ProductVersionDataBeanProvider;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HeaderFooterRendering {
    public static final String META_X_UA_COMPATIBLE = "meta.x.ua.compatible";
    private static final Logger log = Logger.getLogger(HeaderFooterRendering.class);
    private final ApplicationProperties applicationProperties;
    private final PluginAccessor pluginAccessor;
    private final PageBuilderService pageBuilderService;
    private final WebInterfaceManager webInterfaceManager;
    private final ProductVersionDataBeanProvider productVersionDataBeanProvider;
    private final WebResourceUrlProvider webResourceUrlProvider;

    public HeaderFooterRendering(ApplicationProperties applicationProperties, PluginAccessor pluginAccessor, PageBuilderService pageBuilderService, WebInterfaceManager webInterfaceManager, ProductVersionDataBeanProvider productVersionDataBeanProvider, WebResourceUrlProvider webResourceUrlProvider) {
        this.applicationProperties = applicationProperties;
        this.pluginAccessor = pluginAccessor;
        this.pageBuilderService = pageBuilderService;
        this.webInterfaceManager = webInterfaceManager;
        this.productVersionDataBeanProvider = productVersionDataBeanProvider;
        this.webResourceUrlProvider = webResourceUrlProvider;
    }

    public void includeHeadResources(JspWriter out) {
        this.pageBuilderService.assembler().resources().requireWebResource("jira.webresources:global-static").requireWebResource("jira.webresources:key-commands").requireWebResource("jira.webresources:header").requireContext("atl.global").requireContext("jira.global");
        this.pageBuilderService.assembler().assembled().drainIncludedResources().writeHtmlTags((Writer)out, com.atlassian.webresource.api.UrlMode.RELATIVE);
    }

    public void includeTopNavigation(JspWriter out, HttpServletRequest httpServletRequest, Page page) throws IOException {
        this.includeTopNavigation(out, httpServletRequest, page.getProperty("page.section"), this.getWebFragmentContext("atl.header"));
    }

    public void includeTopNavigation(JspWriter out, HttpServletRequest httpServletRequest, DecoratablePage.ParsedBody parsedBody) throws IOException {
        this.includeTopNavigation(out, httpServletRequest, parsedBody.getPageProperty("page.section"), this.getWebFragmentContext("atl.header"));
    }

    protected void includeTopNavigation(JspWriter out, HttpServletRequest httpServletRequest, String selectedSection, Map<String, Object> webFragmentContext) {
        ArrayList topNavPlugins = Lists.newArrayList((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(TopNavigationModuleDescriptor.class));
        Collections.sort(topNavPlugins, ModuleDescriptorComparator.COMPARATOR);
        if (StringUtils.isNotBlank((String)selectedSection)) {
            httpServletRequest.setAttribute("jira.selected.section", (Object)selectedSection);
        }
        for (TopNavigationModuleDescriptor topNavModuleDescriptor : topNavPlugins) {
            try {
                PluggableTopNavigation topNavigation;
                if (topNavModuleDescriptor.getCondition() == null || !topNavModuleDescriptor.getCondition().shouldDisplay(webFragmentContext) || (topNavigation = (PluggableTopNavigation)topNavModuleDescriptor.getModule()) == null) continue;
                out.write(topNavigation.getHtml(httpServletRequest));
            }
            catch (Exception e) {
                log.error((Object)String.format("Unable to build top navigation from '%s' because of '%s'", topNavModuleDescriptor.getCompleteKey(), e.getMessage()), (Throwable)e);
            }
        }
    }

    public void includeFooters(JspWriter out, HttpServletRequest httpServletRequest) throws IOException {
        ArrayList footerPlugins = Lists.newArrayList((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(FooterModuleDescriptor.class));
        Collections.sort(footerPlugins, ModuleDescriptorComparator.COMPARATOR);
        for (FooterModuleDescriptor footerModuleDescriptor : footerPlugins) {
            PluggableFooter footer = (PluggableFooter)footerModuleDescriptor.getModule();
            try {
                out.write(footer.getFullFooterHtml(httpServletRequest));
            }
            catch (RuntimeException e) {
                log.error((Object)String.format("Unable to build top navigation from '%s' because of '%s'", footer.getClass().getCanonicalName(), e.getMessage()), (Throwable)e);
            }
        }
        AccessLogImprinter imprinter = new AccessLogImprinter(httpServletRequest);
        out.print(imprinter.imprintHiddenHtml());
        out.print(imprinter.imprintHTMLComment());
    }

    public void includeWebPanels(JspWriter out, String location) throws IOException {
        Map<String, Object> context = this.getWebFragmentContext(location);
        List displayableWebPanels = this.webInterfaceManager.getDisplayableWebPanels(location, context);
        for (WebPanel webPanel : displayableWebPanels) {
            try {
                webPanel.writeHtml((Writer)out, context);
            }
            catch (RuntimeException e) {
                log.error((Object)String.format("Unable to include web panel in context '%s' from class '%s' because of '%s'", location, webPanel.getClass().getCanonicalName(), e.getMessage()), (Throwable)e);
            }
        }
    }

    public String getPageTitle(Page originalPage) {
        return this.getPageTitle(originalPage.getTitle());
    }

    public String getPageTitle(DecoratablePage.ParsedHead parsedHead) {
        return this.getPageTitle(parsedHead.getTitle());
    }

    private String getPageTitle(String pageTitle) {
        String appTitle = TextUtils.htmlEncode((String)this.applicationProperties.getDefaultBackedString("jira.title"));
        String actualTitle = pageTitle == null ? appTitle : (pageTitle.equals(appTitle) ? pageTitle : pageTitle + " - " + appTitle);
        return actualTitle;
    }

    public String getXUACompatible(Page originalPage) {
        String xUaCompatible = originalPage.getProperty(META_X_UA_COMPATIBLE);
        if (xUaCompatible == null) {
            xUaCompatible = "IE=Edge";
        }
        return xUaCompatible;
    }

    public String getRelativeResourcePrefix() {
        return this.webResourceUrlProvider.getStaticResourcePrefix(UrlMode.RELATIVE);
    }

    public void includeVersionMetaTags(JspWriter out) throws IOException {
        String metaTags = this.productVersionDataBeanProvider.get().getMetaTags();
        out.write(metaTags);
    }

    public void includeMetadata(JspWriter out) throws IOException {
        HtmlMetadataManager htmlMetadataManager = (HtmlMetadataManager)ComponentAccessor.getComponent(HtmlMetadataManager.class);
        if (htmlMetadataManager != null) {
            htmlMetadataManager.includeMetadata((Writer)out);
        }
    }

    public String getKeyboardShortCutScript(HttpServletRequest httpServletRequest) {
        KeyboardShortcutManager keyboardShortcutManager = (KeyboardShortcutManager)ComponentAccessor.getComponent(KeyboardShortcutManager.class);
        if (keyboardShortcutManager != null) {
            return httpServletRequest.getContextPath() + TextUtils.htmlEncode((String)keyboardShortcutManager.includeShortcuts());
        }
        return "";
    }

    @VisibleForTesting
    Map<String, Object> getWebFragmentContext(String location) {
        return DefaultWebFragmentContext.get((String)location);
    }
}

