/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.myjirahome;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.myjirahome.MyJiraHomeLinker;
import com.atlassian.jira.plugin.myjirahome.MyJiraHomePreference;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.model.WebLink;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class MyJiraHomeLinkerImpl
implements MyJiraHomeLinker {
    private final PluginAccessor pluginAccessor;
    private final MyJiraHomePreference myJiraHomePreference;
    private final ProjectService projectService;
    private final FeatureManager featureManager;

    public MyJiraHomeLinkerImpl(@Nonnull PluginAccessor pluginAccessor, @Nonnull MyJiraHomePreference myJiraHomePreference, @Nonnull ProjectService projectService, @Nonnull FeatureManager featureManager) {
        this.pluginAccessor = pluginAccessor;
        this.myJiraHomePreference = myJiraHomePreference;
        this.projectService = projectService;
        this.featureManager = featureManager;
    }

    @Override
    @Nonnull
    public String getHomeLink(@Nullable User user) {
        String completePluginModuleKey = this.myJiraHomePreference.findHome(user);
        try {
            if (StringUtils.isEmpty((String)completePluginModuleKey)) {
                return this.getDefaultHome(user);
            }
            if (!this.pluginAccessor.isPluginModuleEnabled(completePluginModuleKey)) {
                return this.getDefaultHome(user);
            }
            WebLink link = this.getWebLinkFromWebItemModuleDescriptor(completePluginModuleKey);
            if (link != null) {
                return link.getRenderedUrl(Collections.emptyMap());
            }
            return this.getDefaultHome(user);
        }
        catch (IllegalArgumentException e) {
            return this.getDefaultHome(user);
        }
    }

    @Nullable
    private WebLink getWebLinkFromWebItemModuleDescriptor(@Nonnull String completePluginModuleKey) {
        WebItemModuleDescriptor webItemModuleDescriptor = this.getWebItemModuleDescriptorFromKey(completePluginModuleKey);
        if (webItemModuleDescriptor != null) {
            return webItemModuleDescriptor.getLink();
        }
        return null;
    }

    @Nullable
    private WebItemModuleDescriptor getWebItemModuleDescriptorFromKey(@Nonnull String completePluginModuleKey) {
        ModuleDescriptor pluginModule = this.pluginAccessor.getPluginModule(completePluginModuleKey);
        if (pluginModule instanceof WebItemModuleDescriptor) {
            return (WebItemModuleDescriptor)pluginModule;
        }
        return null;
    }

    private String getDefaultHome(User user) {
        ServiceOutcome allProjects;
        if (user == null && (allProjects = this.projectService.getAllProjects(user)).isValid() && ((List)allProjects.getReturnedValue()).isEmpty() && this.featureManager.isOnDemand()) {
            return "/login.jsp?os_destination=%2Fsecure%2FDashboard.jspa";
        }
        return "/secure/Dashboard.jspa";
    }
}

