/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.keyboardshortcut;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcut;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutModuleDescriptor;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class PluginShortcuts {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    @GuardedBy(value="lock")
    private final Map<String, KeyboardShortcut> shortcuts = Maps.newHashMap();
    @GuardedBy(value="lock")
    @ClusterSafe(value="Driven by plugin state, which is kept in synch across the cluster")
    private final ResettableLazyReference<ImmutableList<KeyboardShortcut>> sortedCopy = new ResettableLazyReference<ImmutableList<KeyboardShortcut>>(){

        protected ImmutableList<KeyboardShortcut> create() throws Exception {
            return Ordering.natural().immutableSortedCopy(PluginShortcuts.this.shortcuts.values());
        }
    };

    PluginShortcuts() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reInit(List<KeyboardShortcutModuleDescriptor> descriptors) {
        this.lock.writeLock().lock();
        try {
            this.shortcuts.clear();
            this.sortedCopy.reset();
            for (KeyboardShortcutModuleDescriptor descriptor : descriptors) {
                this.shortcuts.put(descriptor.getCompleteKey(), (KeyboardShortcut)descriptor.getModule());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String moduleKey, KeyboardShortcut keyboardShortcut) {
        this.lock.writeLock().lock();
        try {
            this.shortcuts.put(moduleKey, keyboardShortcut);
            this.sortedCopy.reset();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String moduleKey) {
        this.lock.writeLock().lock();
        try {
            this.shortcuts.remove(moduleKey);
            this.sortedCopy.reset();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<KeyboardShortcut> getAll() {
        this.lock.readLock().lock();
        try {
            ImmutableList immutableList = (ImmutableList)this.sortedCopy.get();
            return immutableList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

