/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.validator.NumberOfArgumentsValidator;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import java.util.Collections;
import java.util.List;

public abstract class AbstractUserCapabilityFunction
extends AbstractJqlFunction {
    private static final int MIN_EXPECTED_ARGS = 1;
    private static final int MAX_EXPECTED_ARGS = 1;
    protected final UserUtil userUtil;

    public AbstractUserCapabilityFunction(UserUtil userUtil) {
        this.userUtil = (UserUtil)Assertions.notNull((String)"userUtil", (Object)userUtil);
    }

    public MessageSet validate(User searcher, FunctionOperand functionOperand, TerminalClause terminalClause) {
        I18nHelper i18n = this.getI18n();
        MessageSet messageSet = new NumberOfArgumentsValidator(1, i18n).validate(functionOperand);
        if (!messageSet.hasAnyErrors()) {
            if (functionOperand.getArgs().size() == 1 && searcher == null) {
                messageSet.addErrorMessage(i18n.getText("jira.jql.function.anonymous.disallowed", this.getFunctionName()));
            }
            messageSet.addMessageSet(this.validateCapability((String)functionOperand.getArgs().get(0), i18n));
        }
        return messageSet;
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 1;
    }

    protected abstract MessageSet validateCapability(String var1, I18nHelper var2);

    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, FunctionOperand functionOperand, TerminalClause terminalClause) {
        Assertions.notNull((String)"queryCreationContext", (Object)queryCreationContext);
        if (functionOperand.getArgs().size() < 1) {
            return Collections.emptyList();
        }
        String requiredCapability = (String)functionOperand.getArgs().get(0);
        ApplicationUser user = queryCreationContext.getApplicationUser();
        if (user == null || requiredCapability == null || requiredCapability.length() == 0) {
            return Collections.emptyList();
        }
        return this.getFunctionValuesList(queryCreationContext, functionOperand, user, requiredCapability);
    }

    protected abstract List<QueryLiteral> getFunctionValuesList(QueryCreationContext var1, FunctionOperand var2, ApplicationUser var3, String var4);

    protected abstract String getUserNotFoundMessageKey();
}

