/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.aboutpagepanel;

import com.atlassian.jira.license.thirdparty.BomParser;
import com.atlassian.jira.plugin.aboutpagepanel.AboutPagePanelModuleDescriptorImpl;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BomParserImpl
implements BomParser {
    private static final Logger log = LoggerFactory.getLogger(BomParserImpl.class);

    @Override
    public List<AboutPagePanelModuleDescriptorImpl.Material> extractLgplMaterials(String bomContents) {
        ArrayList al = Lists.newArrayList();
        bomContents = bomContents.replaceAll("\\r", "\n");
        String[] materialLines = bomContents.split("\\n");
        for (String materialLine : materialLines = StringUtils.stripAll((String[])materialLines)) {
            if (materialLine.startsWith("#") || !materialLine.contains("GNU Lesser General Public License")) continue;
            String[] materialInfo = materialLine.split(",", -1);
            if (materialInfo.length != 5) {
                log.info(String.format("Could not parse license info line: %s", materialLine));
                continue;
            }
            materialInfo = StringUtils.stripAll((String[])materialInfo);
            String libraryName = materialInfo[0];
            String mavenInfo = materialInfo[1];
            String url = materialInfo[3];
            if (StringUtils.isEmpty((String)(libraryName + mavenInfo + url))) continue;
            String license = materialInfo[2];
            String artifactType = materialInfo[4];
            al.add(new AboutPagePanelModuleDescriptorImpl.Material(libraryName, mavenInfo, license, url, artifactType));
        }
        return al;
    }
}

