/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.plugin.PluginVersion;
import com.atlassian.jira.plugin.PluginVersionImpl;
import com.atlassian.jira.plugin.PluginVersionStore;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class OfBizPluginVersionStore
implements PluginVersionStore {
    public static final String PLUGIN_VERSION_ENTITY_NAME = "PluginVersion";
    public static final String PLUGIN_VERSION_ID = "id";
    public static final String PLUGIN_VERSION_KEY = "key";
    public static final String PLUGIN_VERSION_NAME = "name";
    public static final String PLUGIN_VERSION_VERSION = "version";
    public static final String PLUGIN_VERSION_CREATED = "created";
    private final OfBizDelegator ofBizDelegator;

    public OfBizPluginVersionStore(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public PluginVersion create(PluginVersion pluginVersion) {
        if (pluginVersion == null) {
            throw new IllegalArgumentException("Can not create a plugin version record from a null PluginVersion.");
        }
        return this.convertFromGV(this.ofBizDelegator.createValue(PLUGIN_VERSION_ENTITY_NAME, this.convertToParams(pluginVersion)));
    }

    @Override
    public PluginVersion update(PluginVersion pluginVersion) {
        if (pluginVersion == null || pluginVersion.getId() == null) {
            throw new IllegalArgumentException("You can not update a plugin version with a null id.");
        }
        GenericValue pluginVersionGV = this.ofBizDelegator.findById(PLUGIN_VERSION_ENTITY_NAME, pluginVersion.getId());
        if (pluginVersionGV == null) {
            throw new IllegalArgumentException("Unable to find plugin version record with id '" + pluginVersion.getId() + "'");
        }
        pluginVersionGV.set(PLUGIN_VERSION_KEY, (Object)pluginVersion.getKey());
        pluginVersionGV.set(PLUGIN_VERSION_NAME, (Object)pluginVersion.getName());
        pluginVersionGV.set(PLUGIN_VERSION_VERSION, (Object)pluginVersion.getVersion());
        pluginVersionGV.set(PLUGIN_VERSION_CREATED, (Object)new Timestamp(pluginVersion.getCreated().getTime()));
        try {
            pluginVersionGV.store();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Unable to update plugin version with id '" + pluginVersion.getId() + "'.", (Throwable)e);
        }
        return this.convertFromGV(pluginVersionGV);
    }

    @Override
    public boolean delete(Long pluginVersionId) {
        if (pluginVersionId == null) {
            throw new IllegalArgumentException("Unable to delete a plugin version with a null id.");
        }
        return this.ofBizDelegator.removeByAnd(PLUGIN_VERSION_ENTITY_NAME, EasyMap.build((Object)PLUGIN_VERSION_ID, (Object)pluginVersionId)) == 1;
    }

    @Override
    public PluginVersion getById(Long pluginVersionId) {
        GenericValue pluginVersionGV = this.ofBizDelegator.findById(PLUGIN_VERSION_ENTITY_NAME, pluginVersionId);
        if (pluginVersionGV != null) {
            return this.convertFromGV(pluginVersionGV);
        }
        return null;
    }

    @Override
    public List<PluginVersion> getAll() {
        return CollectionUtil.transform((Iterable)this.ofBizDelegator.findAll(PLUGIN_VERSION_ENTITY_NAME), (Function)new Function<GenericValue, PluginVersion>(){

            public PluginVersion get(GenericValue input) {
                return OfBizPluginVersionStore.this.convertFromGV(input);
            }
        });
    }

    @Override
    public void deleteByKey(String pluginKey) {
        if (pluginKey == null) {
            throw new IllegalArgumentException("Unable to delete a plugin version with a null key.");
        }
        this.ofBizDelegator.removeByAnd(PLUGIN_VERSION_ENTITY_NAME, EasyMap.build((Object)PLUGIN_VERSION_KEY, (Object)pluginKey));
    }

    @Override
    public long save(PluginVersion pluginVersion) {
        Assertions.notNull((String)"pluginVersion", (Object)pluginVersion);
        PluginVersion existingRecord = this.getByKey(pluginVersion.getKey());
        if (existingRecord == null) {
            return this.create(pluginVersion).getId();
        }
        this.update(new PluginVersionImpl(existingRecord.getId(), pluginVersion.getKey(), pluginVersion.getName(), pluginVersion.getVersion(), existingRecord.getCreated()));
        return existingRecord.getId();
    }

    private PluginVersion getByKey(String pluginKey) {
        List pluginVersionValues = this.ofBizDelegator.findByField(PLUGIN_VERSION_ENTITY_NAME, PLUGIN_VERSION_KEY, (Object)pluginKey);
        if (pluginVersionValues.isEmpty()) {
            return null;
        }
        if (pluginVersionValues.size() > 1) {
            throw new IllegalStateException("Found > 1 PluginVersion records with key = '" + pluginKey + "':" + pluginVersionValues);
        }
        return this.convertFromGV((GenericValue)pluginVersionValues.get(0));
    }

    PluginVersion convertFromGV(GenericValue pluginVersionGV) {
        Long id = pluginVersionGV.getLong(PLUGIN_VERSION_ID);
        String key = pluginVersionGV.getString(PLUGIN_VERSION_KEY);
        String name = pluginVersionGV.getString(PLUGIN_VERSION_NAME);
        String version = pluginVersionGV.getString(PLUGIN_VERSION_VERSION);
        Timestamp created = pluginVersionGV.getTimestamp(PLUGIN_VERSION_CREATED);
        return new PluginVersionImpl(id, key, name, version, created);
    }

    Map<String, Object> convertToParams(PluginVersion pluginVersion) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Long id = pluginVersion.getId();
        if (id != null) {
            params.put(PLUGIN_VERSION_ID, id);
        }
        params.put(PLUGIN_VERSION_KEY, pluginVersion.getKey());
        params.put(PLUGIN_VERSION_NAME, pluginVersion.getName());
        params.put(PLUGIN_VERSION_VERSION, pluginVersion.getVersion());
        params.put(PLUGIN_VERSION_CREATED, new Timestamp(pluginVersion.getCreated().getTime()));
        return params;
    }
}

