/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.jira.permission.Permission;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;

public class SchemePermissions {
    private ImmutableMap<Integer, Permission> permissions;
    private ImmutableMap<Integer, Permission> projectPermissions;
    private ImmutableMap<Integer, Permission> issuePermissions;
    private ImmutableMap<Integer, Permission> votersAndWatchersPermissions;
    private ImmutableMap<Integer, Permission> timeTrackingPermissions;
    private ImmutableMap<Integer, Permission> commentsPermissions;
    private ImmutableMap<Integer, Permission> attachmentsPermissions;

    private ImmutableMap<Integer, Permission> toMap(Permission ... permissions) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (Permission permission : permissions) {
            map.put(permission.getId(), permission);
        }
        return ImmutableMap.copyOf((Map)map);
    }

    public synchronized Map<Integer, Permission> getProjectPermissions() {
        if (this.projectPermissions == null) {
            this.projectPermissions = this.toMap(Permission.PROJECT_ADMIN, Permission.BROWSE, Permission.VIEW_VERSION_CONTROL, Permission.VIEW_WORKFLOW_READONLY);
        }
        return this.projectPermissions;
    }

    public synchronized Map<Integer, Permission> getIssuePermissions() {
        if (this.issuePermissions == null) {
            this.issuePermissions = this.toMap(Permission.CREATE_ISSUE, Permission.EDIT_ISSUE, Permission.SCHEDULE_ISSUE, Permission.MOVE_ISSUE, Permission.ASSIGN_ISSUE, Permission.ASSIGNABLE_USER, Permission.RESOLVE_ISSUE, Permission.CLOSE_ISSUE, Permission.MODIFY_REPORTER, Permission.DELETE_ISSUE, Permission.LINK_ISSUE, Permission.SET_ISSUE_SECURITY);
        }
        return this.issuePermissions;
    }

    public synchronized Map<Integer, Permission> getVotersAndWatchersPermissions() {
        if (this.votersAndWatchersPermissions == null) {
            this.votersAndWatchersPermissions = this.toMap(Permission.VIEW_VOTERS_AND_WATCHERS, Permission.MANAGE_WATCHER_LIST);
        }
        return this.votersAndWatchersPermissions;
    }

    public synchronized Map<Integer, Permission> getCommentsPermissions() {
        if (this.commentsPermissions == null) {
            this.commentsPermissions = this.toMap(Permission.COMMENT_ISSUE, Permission.COMMENT_EDIT_ALL, Permission.COMMENT_EDIT_OWN, Permission.COMMENT_DELETE_ALL, Permission.COMMENT_DELETE_OWN);
        }
        return this.commentsPermissions;
    }

    public synchronized Map<Integer, Permission> getAttachmentsPermissions() {
        if (this.attachmentsPermissions == null) {
            this.attachmentsPermissions = this.toMap(Permission.CREATE_ATTACHMENT, Permission.ATTACHMENT_DELETE_ALL, Permission.ATTACHMENT_DELETE_OWN);
        }
        return this.attachmentsPermissions;
    }

    public synchronized Map<Integer, Permission> getTimeTrackingPermissions() {
        if (this.timeTrackingPermissions == null) {
            this.timeTrackingPermissions = this.toMap(Permission.WORK_ISSUE, Permission.WORKLOG_EDIT_OWN, Permission.WORKLOG_EDIT_ALL, Permission.WORKLOG_DELETE_OWN, Permission.WORKLOG_DELETE_ALL);
        }
        return this.timeTrackingPermissions;
    }

    public synchronized Map<Integer, Permission> getSchemePermissions() {
        if (this.permissions == null) {
            this.permissions = ImmutableMap.builder().putAll(this.getProjectPermissions()).putAll(this.getIssuePermissions()).putAll(this.getVotersAndWatchersPermissions()).putAll(this.getCommentsPermissions()).putAll(this.getAttachmentsPermissions()).putAll(this.getTimeTrackingPermissions()).build();
        }
        return this.permissions;
    }

    public boolean schemePermissionExists(Integer id) {
        return this.getSchemePermissions().containsKey(id);
    }

    public String getPermissionName(Integer id) {
        return this.getSchemePermissions().get(id).getNameKey();
    }

    public String getPermissionDescription(int id) {
        if (this.getSchemePermissions().get(id) != null) {
            return this.getSchemePermissions().get(id).getDescription();
        }
        return "";
    }
}

