/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.DefaultOfBizDelegator;
import com.atlassian.jira.ofbiz.IssueGenericValueFactory;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.ofbiz.WrappingOfBizListIterator;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.GenericModelException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.Transformation;
import org.ofbiz.core.entity.model.ModelReader;

public class WrappingOfBizDelegator
implements OfBizDelegator {
    private final OfBizDelegator delegate;

    public WrappingOfBizDelegator(DelegatorInterface delegatorInterface) {
        this(new DefaultOfBizDelegator(delegatorInterface));
    }

    @VisibleForTesting
    WrappingOfBizDelegator(OfBizDelegator delegate) {
        Validate.notNull((Object)delegate);
        this.delegate = delegate;
    }

    public List<GenericValue> findByField(String entityName, String fieldName, Object fieldValue) {
        List result = this.delegate.findByField(entityName, fieldName, fieldValue);
        if (entityName.equals("Issue")) {
            return IssueGenericValueFactory.wrap(result);
        }
        return result;
    }

    public List<GenericValue> findByField(String entityName, String fieldName, Object fieldValue, String orderBy) {
        List result = this.delegate.findByField(entityName, fieldName, fieldValue, orderBy);
        if (entityName.equals("Issue")) {
            return IssueGenericValueFactory.wrap(result);
        }
        return result;
    }

    public List<GenericValue> findByAnd(String entityName, Map<String, ?> fields) throws DataAccessException {
        List result = this.delegate.findByAnd(entityName, fields);
        if (entityName.equals("Issue")) {
            return IssueGenericValueFactory.wrap(result);
        }
        return result;
    }

    public List<GenericValue> findByAnd(String entityName, Map<String, ?> fields, List<String> orderBy) throws DataAccessException {
        List result = this.delegate.findByAnd(entityName, fields, orderBy);
        if (entityName.equals("Issue")) {
            return IssueGenericValueFactory.wrap(result);
        }
        return result;
    }

    public List<GenericValue> findByAnd(String entityName, List<EntityCondition> expressions) throws DataAccessException {
        List result = this.delegate.findByAnd(entityName, expressions);
        if (entityName.equals("Issue")) {
            return IssueGenericValueFactory.wrap(result);
        }
        return result;
    }

    public List<GenericValue> findByOr(String entityName, List<? extends EntityCondition> expressions, List<String> orderBy) throws DataAccessException {
        List result = this.delegate.findByOr(entityName, expressions, orderBy);
        if (entityName.equals("Issue")) {
            return IssueGenericValueFactory.wrap(result);
        }
        return result;
    }

    public List<GenericValue> findByLike(String entityName, Map<String, ?> map) throws DataAccessException {
        List result = this.delegate.findByLike(entityName, map);
        if (entityName.equals("Issue")) {
            return IssueGenericValueFactory.wrap(result);
        }
        return result;
    }

    public List<GenericValue> findByLike(String entityName, Map<String, ?> map, List<String> orderBy) throws DataAccessException {
        List result = this.delegate.findByLike(entityName, map, orderBy);
        if (entityName.equals("Issue")) {
            return IssueGenericValueFactory.wrap(result);
        }
        return result;
    }

    public void removeAll(List<GenericValue> genericValues) throws DataAccessException {
        this.delegate.removeAll(genericValues);
    }

    public int removeByAnd(String s, Map<String, ?> map) throws DataAccessException {
        return this.delegate.removeByAnd(s, map);
    }

    public int removeByCondition(String entityName, EntityCondition condition) throws DataAccessException {
        return this.delegate.removeByCondition(entityName, condition);
    }

    public int removeById(String entityName, Long id) {
        return this.delegate.removeById(entityName, id);
    }

    public int removeValue(GenericValue value) throws DataAccessException {
        return this.delegate.removeValue(value);
    }

    public void storeAll(List<GenericValue> genericValues) throws DataAccessException {
        this.delegate.storeAll(genericValues);
    }

    public List<GenericValue> findAll(String s) throws DataAccessException {
        return IssueGenericValueFactory.wrap(this.delegate.findAll(s));
    }

    public List<GenericValue> findAll(String s, List<String> orderBy) throws DataAccessException {
        return IssueGenericValueFactory.wrap(this.delegate.findAll(s, orderBy));
    }

    public void store(GenericValue gv) throws DataAccessException {
        this.delegate.store(gv);
    }

    public GenericValue createValue(String entityName, Map<String, Object> fields) throws DataAccessException {
        return IssueGenericValueFactory.wrap(this.delegate.createValue(entityName, fields));
    }

    public GenericValue makeValue(String entityName) {
        return IssueGenericValueFactory.wrap(this.delegate.makeValue(entityName));
    }

    public GenericValue makeValue(String entityName, Map<String, Object> fields) {
        return IssueGenericValueFactory.wrap(this.delegate.makeValue(entityName, fields));
    }

    public GenericValue findById(String entityName, Long id) throws DataAccessException {
        return IssueGenericValueFactory.wrap(this.delegate.findById(entityName, id));
    }

    public GenericValue findByPrimaryKey(String entityName, Long id) throws DataAccessException {
        return IssueGenericValueFactory.wrap(this.delegate.findByPrimaryKey(entityName, id));
    }

    public GenericValue findByPrimaryKey(String entityName, Map<String, ?> fields) throws DataAccessException {
        return IssueGenericValueFactory.wrap(this.delegate.findByPrimaryKey(entityName, fields));
    }

    public List<GenericValue> getRelated(String relationName, GenericValue gv) throws DataAccessException {
        return IssueGenericValueFactory.wrap(this.delegate.getRelated(relationName, gv));
    }

    public List<GenericValue> getRelated(String relationName, GenericValue gv, List<String> orderBy) throws DataAccessException {
        return IssueGenericValueFactory.wrap(this.delegate.getRelated(relationName, gv, orderBy));
    }

    public boolean removeRelated(String relationName, GenericValue schemeGv) {
        return this.delegate.removeRelated(relationName, schemeGv);
    }

    public long getCount(String entityName) throws DataAccessException {
        return this.delegate.getCount(entityName);
    }

    public long getCountByAnd(String entityName, Map<String, ?> fields) {
        return this.delegate.getCountByAnd(entityName, fields);
    }

    public List<GenericValue> findByCondition(String entityName, EntityCondition entityCondition, Collection<String> fieldsToSelect, List<String> orderBy) throws DataAccessException {
        List result = this.delegate.findByCondition(entityName, entityCondition, fieldsToSelect, orderBy);
        if (entityName.equals("Issue")) {
            return IssueGenericValueFactory.wrap(result);
        }
        return result;
    }

    public List<GenericValue> findByCondition(String entityName, EntityCondition entityCondition, Collection<String> fieldsToSelect) throws DataAccessException {
        List result = this.delegate.findByCondition(entityName, entityCondition, fieldsToSelect);
        if (entityName.equals("Issue")) {
            return IssueGenericValueFactory.wrap(result);
        }
        return result;
    }

    public ModelReader getModelReader() {
        return this.delegate.getModelReader();
    }

    public void refreshSequencer() {
        this.delegate.refreshSequencer();
    }

    public DelegatorInterface getDelegatorInterface() {
        return this.delegate.getDelegatorInterface();
    }

    public OfBizListIterator findListIteratorByCondition(String entityType, EntityCondition condition) throws DataAccessException {
        return new WrappingOfBizListIterator(this.delegate.findListIteratorByCondition(entityType, condition));
    }

    public OfBizListIterator findListIteratorByCondition(String entityName, EntityCondition whereEntityCondition, EntityCondition havingEntityCondition, Collection<String> fieldsToSelect, List<String> orderBy, EntityFindOptions entityFindOptions) throws DataAccessException {
        return new WrappingOfBizListIterator(this.delegate.findListIteratorByCondition(entityName, whereEntityCondition, havingEntityCondition, fieldsToSelect, orderBy, entityFindOptions));
    }

    public int bulkUpdateByPrimaryKey(String entityName, Map<String, ?> updateValues, List<Long> keys) throws DataAccessException {
        return this.delegate.bulkUpdateByPrimaryKey(entityName, updateValues, keys);
    }

    public int bulkUpdateByAnd(String entityName, Map<String, ?> updateValues, Map<String, ?> criteria) throws DataAccessException {
        return this.delegate.bulkUpdateByAnd(entityName, updateValues, criteria);
    }

    public int bulkCopyColumnValuesByAnd(String entityName, Map updateColumns, Map criteria) throws DataAccessException {
        return this.delegate.bulkCopyColumnValuesByAnd(entityName, updateColumns, criteria);
    }

    public int removeByOr(String entityName, String entityId, List<Long> ids) throws DataAccessException, GenericModelException {
        return this.delegate.removeByOr(entityName, entityId, ids);
    }

    public List<GenericValue> transform(String entityName, EntityCondition entityCondition, List<String> orderBy, String lockField, Transformation transformation) {
        List result = this.delegate.transform(entityName, entityCondition, orderBy, lockField, transformation);
        if ("Issue".equals(entityName)) {
            return IssueGenericValueFactory.wrap(result);
        }
        return result;
    }

    public GenericValue transformOne(String entityName, EntityCondition entityCondition, String lockField, Transformation transformation) {
        return IssueGenericValueFactory.wrap(this.delegate.transformOne(entityName, entityCondition, lockField, transformation));
    }
}

