/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

public class OfBizLogHelper {
    private static final String BIND_PLACEHOLDER_REGEX = "\\?";

    public static String formatSQL(String sqlString, List<?> parameterValues) {
        String formattedSql = sqlString;
        if (parameterValues != null) {
            for (Object parameterValue : parameterValues) {
                formattedSql = formattedSql.replaceFirst(BIND_PLACEHOLDER_REGEX, "'" + parameterValue + "'");
            }
        }
        return '\"' + formattedSql + '\"';
    }

    public static String logTheCallStack() {
        CallStack rte = new CallStack();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        rte.printStackTrace(pw);
        return OfBizLogHelper.shortenStackTrace(sw);
    }

    private static String shortenStackTrace(StringWriter stackTraceWriter) {
        int lineIndex;
        String stackTrace = stackTraceWriter.toString();
        int filterIndex = stackTrace.indexOf(".doFilter");
        if (filterIndex == -1) {
            filterIndex = stackTrace.indexOf(".contextInitialized(");
        }
        if (filterIndex != -1 && (lineIndex = stackTrace.lastIndexOf("\n", filterIndex)) != -1) {
            stackTrace = stackTrace.substring(0, lineIndex) + "\n\t...";
        }
        return OfBizLogHelper.filterStacktraceStart(stackTrace);
    }

    private static String filterStacktraceStart(String stackTrace) {
        String[] lines;
        StringBuilder sb = new StringBuilder(stackTrace.length());
        boolean doneFilteringFirstBit = false;
        for (String line : lines = stackTrace.split("\\n")) {
            if (!doneFilteringFirstBit) {
                String tl = line.trim();
                if (tl.indexOf("com.atlassian.jira.ofbiz") != -1 || tl.startsWith("at org.ofbiz.core.entity")) continue;
                sb.append("call stack\n\t...\n");
                doneFilteringFirstBit = true;
            }
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    private static class CallStack
    extends RuntimeException {
        private CallStack() {
        }
    }
}

