/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification.type;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.type.AbstractNotificationType;
import com.atlassian.jira.notification.type.ApplicationUserToRecipient;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class AllWatchers
extends AbstractNotificationType {
    private static final Logger log = Logger.getLogger(AllWatchers.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final IssueManager issueManager;

    public AllWatchers(JiraAuthenticationContext jiraAuthenticationContext, IssueManager issueManager) {
        this.jiraAuthenticationContext = (JiraAuthenticationContext)Assertions.notNull((Object)jiraAuthenticationContext);
        this.issueManager = (IssueManager)Assertions.notNull((Object)issueManager);
    }

    @Override
    public List<NotificationRecipient> getRecipients(IssueEvent event, String argument) {
        try {
            List watchers = this.getFromEventParams(event);
            if (watchers == null) {
                watchers = this.issueManager.getWatchersFor(event.getIssue());
            }
            return Lists.transform(watchers, (Function)ApplicationUserToRecipient.INSTANCE);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    private List<ApplicationUser> getFromEventParams(IssueEvent event) {
        return ApplicationUsers.from((Collection)((List)event.getParams().get(IssueEvent.WATCHERS_PARAM_NAME)));
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.notification.types.all.watchers");
    }
}

