/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.mail.MailThreadManager;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.mail.MailUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class MailThreadManagerImpl
implements MailThreadManager {
    private static final Logger log = Logger.getLogger(MailThreadManagerImpl.class);
    private final OfBizDelegator ofBizDelegator;
    private final IssueManager issueManager;
    private final EventTypeManager eventTypeManager;

    public MailThreadManagerImpl(OfBizDelegator ofBizDelegator, IssueManager issueManager, EventTypeManager eventTypeManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.issueManager = issueManager;
        this.eventTypeManager = eventTypeManager;
    }

    public void storeIncomingMessageId(String messageId, String senderAddress, Issue issue, MailThreadManager.MailAction action) {
        Assertions.notNull((String)"messageId", (Object)messageId);
        Assertions.notNull((String)"issue", (Object)issue);
        Assertions.notNull((String)"action", (Object)action);
        FieldMap fields = new FieldMap();
        fields.put((Object)"type", (Object)action.toString());
        fields.put((Object)"source", (Object)issue.getId());
        fields.put((Object)"email", (Object)senderAddress);
        fields.put((Object)"messageid", (Object)messageId);
        this.ofBizDelegator.createValue("NotificationInstance", (Map)fields);
    }

    public void createMailThread(String type, Long source, String emailAddress, String messageId) {
        if (messageId == null || messageId.trim().isEmpty()) {
            return;
        }
        if (type != null && (type.equals("ISSUE_CREATED_FROM_EMAIL") || type.equals("ISSUE_COMMENTED_FROM_EMAIL"))) {
            FieldMap fields = new FieldMap();
            fields.put((Object)"type", (Object)type);
            fields.put((Object)"source", (Object)source);
            fields.put((Object)"email", (Object)emailAddress);
            fields.put((Object)"messageid", (Object)messageId);
            try {
                this.ofBizDelegator.createValue("NotificationInstance", (Map)fields);
            }
            catch (DataAccessException e) {
                log.warn((Object)("Unable to store messageId details for email for issue '" + source + "' emailAddress '" + emailAddress + "'."), (Throwable)e);
            }
        }
    }

    public void threadNotificationEmail(Email email, Long issueId) {
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        if (issue == null) {
            throw new IllegalArgumentException("Invalid issueId " + issueId);
        }
        this.threadNotificationEmail(email, (Issue)issue);
    }

    public void threadNotificationEmail(Email email, Issue issue) {
        String host = MailUtils.getLocalHostName();
        String parentMessageId = "<JIRA." + issue.getId() + "." + issue.getCreated().getTime() + "@" + host + ">";
        email.setInReplyTo(parentMessageId);
        email.addHeader("References", parentMessageId);
    }

    public String getThreadType(Long eventTypeId) {
        if (EventType.ISSUE_CREATED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_CREATED;
        }
        if (EventType.ISSUE_ASSIGNED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_ASSIGNED;
        }
        if (EventType.ISSUE_RESOLVED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_RESOLVED;
        }
        if (EventType.ISSUE_CLOSED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_CLOSED;
        }
        if (EventType.ISSUE_REOPENED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_REOPENED;
        }
        if (EventType.ISSUE_COMMENTED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_COMMENTED;
        }
        if (EventType.ISSUE_COMMENT_EDITED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_COMMENT_EDITED;
        }
        if (EventType.ISSUE_DELETED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_DELETED;
        }
        if (EventType.ISSUE_UPDATED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_UPDATED;
        }
        if (EventType.ISSUE_WORKLOGGED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_WORKLOGGED;
        }
        if (EventType.ISSUE_WORKLOG_UPDATED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_WORKLOG_UPDATED;
        }
        if (EventType.ISSUE_WORKLOG_DELETED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_WORKLOG_DELETED;
        }
        if (EventType.ISSUE_WORKSTARTED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_WORKSTARTED;
        }
        if (EventType.ISSUE_WORKSTOPPED_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_WORKSTOPPED;
        }
        if (EventType.ISSUE_GENERICEVENT_ID.equals(eventTypeId)) {
            return NOTIFICATION_ISSUE_GENERICEVENT;
        }
        if (this.eventTypeManager.isEventTypeExists(eventTypeId)) {
            return "NOTIFICATION_" + eventTypeId;
        }
        throw new IllegalArgumentException("Unable to thread this notification as the event type " + eventTypeId + " is unknown.");
    }

    public GenericValue getAssociatedIssue(Message message) {
        Issue issue = this.getAssociatedIssueObject(message);
        if (issue == null) {
            return null;
        }
        return issue.getGenericValue();
    }

    @Nullable
    public Issue getAssociatedIssueObject(Message message) {
        try {
            String[] messageIds = message.getHeader("In-Reply-To");
            if (messageIds != null && messageIds.length > 0) {
                for (String messageId : messageIds) {
                    Issue issue = this.getAssociatedIssueFromMessageId(messageId);
                    if (issue == null) continue;
                    return issue;
                }
            } else {
                log.debug((Object)"No In-Reply-To header found");
            }
            String[] values = message.getHeader("References");
            if (values != null && values.length > 0) {
                for (String value : values) {
                    for (String messageId : this.extractMessageIdsFromReferences(value)) {
                        Issue issue = this.getAssociatedIssueFromMessageId(messageId);
                        if (issue == null) continue;
                        return issue;
                    }
                }
            } else {
                log.debug((Object)("No References header found for message '" + message.getSubject() + "'"));
            }
            return null;
        }
        catch (MessagingException e) {
            log.error((Object)"Error occurred while determining message id of an e-mail message.", (Throwable)e);
            return null;
        }
    }

    private List<String> extractMessageIdsFromReferences(String value) {
        ArrayList<String> messageIds = new ArrayList<String>();
        if (value == null) {
            return messageIds;
        }
        int nextMessageIdIndex = value.indexOf(60);
        while (nextMessageIdIndex > -1) {
            int endIndex = value.indexOf(62, nextMessageIdIndex);
            if (endIndex == -1) {
                nextMessageIdIndex = -1;
                continue;
            }
            messageIds.add(value.substring(nextMessageIdIndex, endIndex + 1));
            nextMessageIdIndex = value.indexOf(60, endIndex);
        }
        return messageIds;
    }

    private Issue getAssociatedIssueFromMessageId(String messageId) {
        int index = messageId.indexOf(";");
        if (index > 0) {
            messageId = messageId.substring(0, index);
        }
        if (messageId.startsWith("<JIRA.")) {
            return this.parseIssueFromMessageId(messageId);
        }
        return this.findIssueFromLegacyMessageId(messageId);
    }

    private Issue parseIssueFromMessageId(String messageId) {
        long createdDate;
        Long issueId;
        String[] sections = messageId.split("\\.");
        try {
            issueId = new Long(sections[1]);
            createdDate = Long.parseLong(sections[2]);
        }
        catch (RuntimeException ex) {
            log.error((Object)("Unable to parse incoming In-Reply-To header " + messageId));
            return null;
        }
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        if (issue == null) {
            return null;
        }
        if (issue.getCreated().getTime() / 1000L == createdDate / 1000L) {
            return issue;
        }
        log.warn((Object)("Received In-Reply-To header " + messageId + " but issue " + issue.getKey() + " does not match incoming creation date - assuming this is from another server and ignoring."));
        return null;
    }

    private Issue findIssueFromLegacyMessageId(String messageId) {
        List notificationInstanceGVs = this.ofBizDelegator.findByAnd("NotificationInstance", EasyMap.build((Object)"messageid", (Object)messageId));
        if (notificationInstanceGVs == null || notificationInstanceGVs.isEmpty()) {
            log.debug((Object)("Cannot find any associated issues with message id '" + messageId + "'."));
            return null;
        }
        GenericValue notificationInstanceGV = (GenericValue)notificationInstanceGVs.get(0);
        Long issueId = notificationInstanceGV.getLong("source");
        return this.issueManager.getIssueObject(issueId);
    }

    public int removeAssociatedEntries(Long issueId) {
        return this.ofBizDelegator.removeByAnd("NotificationInstance", EasyMap.build((Object)"source", (Object)issueId));
    }
}

