/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.mail.JiraMailUtils;
import com.atlassian.jira.mail.builder.EmailBuilder;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.mail.queue.MailQueueItem;
import com.google.common.collect.Maps;
import java.util.Map;

public class MailServiceQueueItemBuilder {
    private final NotificationRecipient recipient;
    private final Map<String, Object> context;
    private final User replyTo;
    private final String subjectTemplatePath;
    private final String bodyTemplatePath;

    public MailServiceQueueItemBuilder(User replyTo, NotificationRecipient recipient, String subjectTemplatePath, String bodyTemplatePath, Map<String, Object> context) {
        this.replyTo = replyTo;
        this.recipient = recipient;
        this.subjectTemplatePath = subjectTemplatePath;
        this.bodyTemplatePath = bodyTemplatePath;
        this.context = context;
    }

    public MailQueueItem buildQueueItem() {
        String projectEmail = null;
        IssueEvent issueEvent = null;
        if (this.context.containsKey("issue")) {
            Issue issue = (Issue)this.context.get("issue");
            projectEmail = JiraMailUtils.getProjectEmailFromIssue(issue);
            issueEvent = new IssueEvent(issue, (Map)Maps.newHashMap(), this.replyTo, Long.valueOf(0L));
        }
        Email email = new Email(this.recipient.getEmail());
        email.setFrom(projectEmail);
        email.setFromName(JiraMailUtils.getFromNameForUser(this.replyTo));
        email.setReplyTo(this.replyTo.getEmailAddress());
        EmailBuilder emailBuilder = issueEvent != null ? new EmailBuilder(email, this.recipient, issueEvent) : new EmailBuilder(email, this.recipient);
        return emailBuilder.withSubjectFromFile(this.subjectTemplatePath).withBodyFromFile(this.bodyTemplatePath).addParameters(this.context).renderLater();
    }
}

