/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.mail.IssueTemplateContext;
import com.atlassian.jira.mail.JiraMailThreader;
import com.atlassian.jira.mail.JiraMailUtils;
import com.atlassian.jira.mail.MailingListCompiler;
import com.atlassian.jira.mail.TemplateContext;
import com.atlassian.jira.mail.TemplateContextFactory;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.TemplateManager;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.AbstractMailQueueItem;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;

public class IssueMailQueueItem
extends AbstractMailQueueItem {
    private static final Logger log = Logger.getLogger(IssueMailQueueItem.class);
    private final TemplateContextFactory templateContextFactory;
    private final JiraAuthenticationContext authenticationContext;
    private final MailingListCompiler mailingListCompiler;
    private final TemplateManager templateManager;
    private final VelocityTemplatingEngine templatingEngine;
    private final MailServerManager mailServerManager;
    private final PermissionManager permissionManager;
    private IssueEvent event;
    private Long templateId;
    private Set<NotificationRecipient> recipientList;
    private String notificationType;

    public IssueMailQueueItem(TemplateContextFactory templateContextFactory, IssueEvent event, Long templateId, Set<NotificationRecipient> recipientList, String notificationType, JiraAuthenticationContext authenticationContext, MailingListCompiler mailingListCompiler, TemplateManager templateManager, VelocityTemplatingEngine templatingEngine, MailServerManager mailServerManager, PermissionManager permissionManager) {
        this.templateContextFactory = templateContextFactory;
        this.event = event;
        this.templateId = templateId;
        this.recipientList = recipientList;
        this.notificationType = notificationType;
        this.authenticationContext = authenticationContext;
        this.mailingListCompiler = mailingListCompiler;
        this.templateManager = templateManager;
        this.templatingEngine = templatingEngine;
        this.mailServerManager = mailServerManager;
        this.permissionManager = permissionManager;
    }

    public String getSubject() {
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        try {
            String subjectTemplate = this.templateManager.getTemplateContent(this.templateId, "subject");
            Map<String, Object> contextParams = this.getIssueContextParams(i18n.getLocale(), this.event);
            contextParams.put("eventTypeName", ((IssueTemplateContext)contextParams.get("context")).getEventTypeName(i18n));
            return this.templatingEngine.render(TemplateSources.fragment((String)subjectTemplate)).applying(contextParams).asPlainText();
        }
        catch (Exception e) {
            log.error((Object)"Could not determine subject", (Throwable)e);
            return i18n.getText("bulk.bean.initialise.error");
        }
    }

    public void send() throws MailException {
        this.incrementSendCount();
        Issue issue = this.event.getIssue();
        try {
            SMTPMailServer smtp = this.mailServerManager.getDefaultSMTPMailServer();
            if (smtp == null) {
                log.warn((Object)"There is no default SMTP Mail server so mail cannot be sent");
            } else {
                if (issue == null) {
                    throw new MailException("Notification not sent; issue no longer exists [event=" + this.event + "]");
                }
                if (!this.recipientList.isEmpty()) {
                    Iterator<NotificationRecipient> iterator = this.recipientList.iterator();
                    while (iterator.hasNext()) {
                        NotificationRecipient recipient = iterator.next();
                        if (this.permissionManager.hasPermission(10, issue, recipient.getUserRecipient())) continue;
                        iterator.remove();
                    }
                    JiraMailThreader threader = new JiraMailThreader(issue);
                    Map<String, Object> contextParams = this.getIssueContextParams(this.authenticationContext.getLocale(), this.event);
                    this.mailingListCompiler.sendLists(this.recipientList, JiraMailUtils.getProjectEmailFromIssue(issue), JiraMailUtils.getFromNameForUser(this.event.getUser()), this.templateId, (String)this.event.getParams().get("baseurl"), contextParams, threader);
                }
            }
        }
        catch (MailException me) {
            throw me;
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new MailException(ex.getMessage(), (Throwable)ex);
        }
    }

    public String toString() {
        Issue issue = this.event.getIssue();
        String issueString = new ToStringBuilder((Object)issue).append("id", (Object)issue.getId()).append("summary", (Object)issue.getSummary()).append("key", (Object)issue.getKey()).append("created", (Object)issue.getCreated()).append("updated", (Object)issue.getUpdated()).append("assignee", (Object)issue.getAssignee()).append("reporter", (Object)issue.getReporter()).toString();
        return new ToStringBuilder((Object)this).append("issue", (Object)issueString).append("remoteUser", (Object)this.event.getUser()).append("notificationType", (Object)this.notificationType).append("eventTypeId", this.event.getEventTypeId().longValue()).append("templateId", this.templateId.longValue()).toString();
    }

    protected Map<String, Object> getIssueContextParams(Locale locale, IssueEvent iEvent) throws GenericEntityException {
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        TemplateContext templateContext = this.templateContextFactory.getTemplateContext(locale, iEvent);
        contextParams.putAll(templateContext.getTemplateParams());
        return contextParams;
    }

    public Set<NotificationRecipient> getRecipientList() {
        return this.recipientList;
    }
}

