/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.mail.BotoCssInliner;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.util.concurrent.ThreadFactories;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class BotocssThreadLauncher
implements JiraLauncher {
    private final AtomicReference<ScheduledExecutorService> executor = new AtomicReference();

    @Override
    public void start() {
        ScheduledExecutorService e = Executors.newSingleThreadScheduledExecutor(ThreadFactories.named((String)"jira-botocss").type(ThreadFactories.Type.DAEMON).build());
        long cleanupSecs = 15L;
        e.scheduleWithFixedDelay(new CacheCleaner(), cleanupSecs, cleanupSecs, TimeUnit.SECONDS);
        this.executor.set(e);
    }

    @Override
    public void stop() {
        ScheduledExecutorService e = this.executor.getAndSet(null);
        if (e != null) {
            e.shutdown();
        }
    }

    private class CacheCleaner
    implements Runnable {
        private CacheCleaner() {
        }

        @Override
        public void run() {
            BotoCssInliner botocssInliner = (BotoCssInliner)ComponentAccessor.getComponent(BotoCssInliner.class);
            if (botocssInliner != null) {
                botocssInliner.performCacheMaintenance();
            }
        }
    }
}

