/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.logging;

import com.atlassian.jira.logging.RollOverLogAppender;
import com.atlassian.jira.startup.JiraHomeStartupCheck;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.File;
import java.util.LinkedList;
import java.util.Queue;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionHandler;

public final class JiraHomeAppender
implements Appender,
OptionHandler,
RollOverLogAppender {
    private static final int QUEUE_MAX = 100;
    private final RollingFileAppender fileAppender = new RollingFileAppender();
    private final JiraHomeStartupCheck startupCheck;
    @GuardedBy(value="this")
    private volatile Queue<LoggingEvent> events = new LinkedList<LoggingEvent>();
    private volatile String fileName;
    private volatile State state = State.WAITING;

    public JiraHomeAppender(JiraHomeStartupCheck startupCheck) {
        this.startupCheck = startupCheck;
    }

    public JiraHomeAppender() {
        this(JiraHomeStartupCheck.getInstance());
    }

    public int getMaxBackupIndex() {
        return this.fileAppender.getMaxBackupIndex();
    }

    public long getMaximumFileSize() {
        return this.fileAppender.getMaximumFileSize();
    }

    public void setMaxBackupIndex(int maxBackups) {
        this.fileAppender.setMaxBackupIndex(maxBackups);
    }

    public void setMaximumFileSize(long maxFileSize) {
        this.fileAppender.setMaximumFileSize(maxFileSize);
    }

    public void setMaxFileSize(String value) {
        this.fileAppender.setMaxFileSize(value);
    }

    public void setFile(String file) {
        this.fileName = ((String)Assertions.notNull((String)"file", (Object)file)).trim();
    }

    public boolean getAppend() {
        return this.fileAppender.getAppend();
    }

    @Override
    public String getFile() {
        return this.fileAppender.getFile();
    }

    public void activateOptions() {
    }

    public boolean getBufferedIO() {
        return this.fileAppender.getBufferedIO();
    }

    public int getBufferSize() {
        return this.fileAppender.getBufferSize();
    }

    public void setAppend(boolean flag) {
        this.fileAppender.setAppend(flag);
    }

    public void setBufferedIO(boolean bufferedIO) {
        this.fileAppender.setBufferedIO(bufferedIO);
    }

    public void setBufferSize(int bufferSize) {
        this.fileAppender.setBufferSize(bufferSize);
    }

    public void setImmediateFlush(boolean value) {
        this.fileAppender.setImmediateFlush(value);
    }

    public boolean getImmediateFlush() {
        return this.fileAppender.getImmediateFlush();
    }

    public void close() {
        this.fileAppender.close();
    }

    public String getEncoding() {
        return this.fileAppender.getEncoding();
    }

    public void setEncoding(String value) {
        this.fileAppender.setEncoding(value);
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.fileAppender.setErrorHandler(eh);
    }

    public boolean requiresLayout() {
        return this.fileAppender.requiresLayout();
    }

    public void addFilter(Filter newFilter) {
        this.fileAppender.addFilter(newFilter);
    }

    public void clearFilters() {
        this.fileAppender.clearFilters();
    }

    public ErrorHandler getErrorHandler() {
        return this.fileAppender.getErrorHandler();
    }

    public Filter getFilter() {
        return this.fileAppender.getFilter();
    }

    public Filter getFirstFilter() {
        return this.fileAppender.getFirstFilter();
    }

    public Layout getLayout() {
        return this.fileAppender.getLayout();
    }

    public String getName() {
        return this.fileAppender.getName();
    }

    public Priority getThreshold() {
        return this.fileAppender.getThreshold();
    }

    public void setLayout(Layout layout) {
        this.fileAppender.setLayout(layout);
    }

    public void setName(String name) {
        this.fileAppender.setName(name);
    }

    public void setThreshold(Priority threshold) {
        this.fileAppender.setThreshold(threshold);
    }

    public void doAppend(LoggingEvent event) {
        if (this.state == State.READY) {
            this.fileAppender.doAppend(event);
        } else if (this.state != State.OFF) {
            this.doAppendSync(event);
        }
    }

    @Override
    public void rollOver() {
        this.fileAppender.rollOver();
    }

    private synchronized void doAppendSync(LoggingEvent event) {
        if (this.state == State.READY) {
            this.fileAppender.doAppend(event);
        } else if (this.state == State.WAITING) {
            State configState = this.configureAppender();
            if (configState == State.WAITING) {
                if (this.events.size() < 100) {
                    this.events.add(event);
                } else if (this.events.size() == 100) {
                    this.events.add(this.createDropEvent());
                }
            } else {
                if (configState == State.READY) {
                    for (LoggingEvent queuedEvent : this.events) {
                        this.fileAppender.doAppend(queuedEvent);
                    }
                    this.fileAppender.doAppend(event);
                }
                this.events = null;
                this.fileName = null;
            }
            this.state = configState;
        }
    }

    private State configureAppender() {
        if (this.fileAppender.getThreshold() == Level.OFF) {
            return State.OFF;
        }
        if (!this.startupCheck.isInitialised()) {
            return State.WAITING;
        }
        if (StringUtils.isBlank((String)this.fileName)) {
            LogLog.error((String)"Unable to log to JIRA home: No fileName specified.");
            return State.OFF;
        }
        if (!this.startupCheck.isOk()) {
            LogLog.debug((String)"Unable to log to JIRA home: Unable to find JIRA home. Logging to working directory.");
            this.fileAppender.setFile(this.fileName);
        } else {
            File homeDirectory = this.startupCheck.getJiraHomeDirectory();
            File homeLogFile = JiraHomeAppender.getHomeLogFile(homeDirectory, this.fileName);
            if (homeLogFile != null) {
                this.fileAppender.setFile(homeLogFile.getAbsolutePath());
            } else {
                this.fileAppender.setFile(this.fileName);
            }
        }
        this.fileAppender.activateOptions();
        return State.READY;
    }

    static File getHomeLogFile(File home, String fileName) {
        File logDirectory = JiraHomeAppender.normalizeFile(new File(home, "log"));
        if (!logDirectory.exists()) {
            if (!logDirectory.mkdirs()) {
                LogLog.error((String)("Unable to log to JIRA home: Unable to create directory '" + logDirectory + "'. Logging to working directory."));
                return null;
            }
        } else if (!logDirectory.isDirectory()) {
            LogLog.error((String)("Unable to log to JIRA home: Log directory '" + logDirectory + "' is not a directory. Logging to working directory."));
            return null;
        }
        return JiraHomeAppender.normalizeFile(new File(logDirectory, fileName));
    }

    private static File normalizeFile(File file) {
        return file.getAbsoluteFile();
    }

    private LoggingEvent createDropEvent() {
        return new LoggingEvent(Category.class.getName(), (Category)Logger.getLogger(this.getClass()), (Priority)Level.ERROR, (Object)"Some log messages dropped during startup. Check application server logs.", null);
    }

    private static enum State {
        WAITING,
        READY,
        OFF;

    }
}

